extends RigidBody2D

var taken = false

onready var main = get_tree().get_root().get_node("Main")
onready var drops = main.get_node("Game/Drops")
var nextlevel = preload("res://scenes/objects/level9.tscn")

func _ready():
	gravity_scale = main.gravity_scale

func _on_LevelH_body_entered(body):
	if body.name.begins_with("LevelH") or body.name.begins_with("@LevelH@"):
		if global_position.y > 242:
			if body.taken == false and taken == false:
				body.taken = true
				taken = true
				main.points += 125
				var pos1 = global_position
				var pos2 = body.global_position
				body.queue_free()
				queue_free()
				var next = nextlevel.instance()
				var between = pos1.linear_interpolate(pos2, 0.5);
				next.global_position = Vector2(between.x, between.y-211)
				drops.call_deferred("add_child", next)
