extends Node

var drops = 3 # highest level for starter drop
var next_drop = 1
var points = 0
var highscores = {}
var achievements = {}
var all_achievements = {"0":false,"1":false}#,"2":false,"3":false} 
var all_achievements_description = {"0":"Reach 5000 points for the first time","1":"Watermelon Game"}#,"2":"insert description","3":"insert description"}
var unlocked_index
var gamemode = "classic"

# global settings for sandbox
var default = {"gravity_scale": 1}
var gravity_scale = 2

func _ready():
	get_tree().quit_on_go_back = false # should work, for disabling quitting app on back button # we can put this in another script if it breaks something here
	var file = File.new()
	if file.file_exists("user://scores.json"): #reads scores
		file.open("user://scores.json", file.READ)
		highscores = parse_json(file.get_as_text())
		
	var file2 = File.new()
		
	if file2.file_exists("user://achiev.json"): #reads achiev
		file2.open("user://achiev.json", file2.READ)
		achievements = parse_json(file2.get_as_text())
		
		if(achievements.size()!=all_achievements.size()):#if new achievements are added with an update
			add_new_achievements() 			
	else:	
		achievements = all_achievements #if there isnt already a file all achiev are false

func _process(delta):
	$UI/Control/Score.text = str(points)
	$UI/Control/Timer.text = str(round($UI/Control/Timer/TimerModeTimer.time_left))
	if !achievements['0']:
		if points > 5000:
			unlocked_index='0'
			unlocked_achievement()

func dropped():
	var ran = RandomNumberGenerator.new()
	ran.randomize()
	var test_drop = ran.randi_range(1, drops)
	if test_drop == next_drop and ran.randi_range(1, 15) > 10:
		dropped()
	else:
		next_drop = test_drop
		$UI/Control/NextDrop.texture = load("res://assets/sprites/objects/level"+str(next_drop)+".png")

var last_touched

func _on_Line_body_entered(body):
	if $UI/Line.get_overlapping_areas().size() == 1:
		$UI/Line/Timer.start()

func _on_Line_body_exited(body):
	if $UI/Line.get_overlapping_areas().size() == 1:
		$UI/Line/Timer.stop()

func game_end():
	$UI2/GameEnd.visible = true
	save_score()

func save_score():
	if points > 0 and highscores.values().has(points) == false:
			
		var score_file = File.new()
		score_file.open("user://scores.json", File.WRITE)
		highscores[highscores.size()+1] = points
		score_file.store_line(to_json(highscores))

func _on_play_pressed():
	reset_game()
	$UI2/Menu.visible = false
	$UI2/Pause.visible = false
	$UI.visible = true
	$Game.visible = true
	if gamemode == "arcade":
		pass

func _on_quit_pressed():
	get_tree().quit()

func _notification(what):
	if what == NOTIFICATION_WM_GO_BACK_REQUEST:
		# probably will not disable physics process but I could...
		$UI2.visible = true
		$UI2/Pause.visible = true

func back_to_menu():
	save_score()
	$UI2/Pause.visible = false
	$UI2/GameEnd.visible = false
	$UI2/Menu.visible = true
	$UI.visible = false
	$Game.visible = false
	#reset_game()

func reset_game():
	points = 0
	next_drop = 1
	$UI/Control/NextDrop.texture = load("res://assets/sprites/objects/level"+str(next_drop)+".png")
	for child in $Game/Drops.get_children():
		child.queue_free()

func _input(event):
	if event.is_action_pressed("ui_cancel"):
		# probably will not disable physics process but I could...
		$UI2.visible = true
		$UI2/Pause.visible = true
	if event.is_action_pressed("action_debug"):
		game_end()

func sort_descending(a, b):
	if a > b:
		return true
		
	return false

func _on_btn_Score_pressed():
	if highscores.size() == 0:
		$UI2/Menu/Score/label_NoScore.visible = true
	else:
		for child in $UI2/Menu/Score/sc_Scores/GridContainer.get_children():
			child.queue_free()
		$UI2/Menu/Score/label_NoScore.visible = false
		var score_panel = load("res://scenes/ui/score.tscn")
		var sorted = highscores.values()
		sorted.sort_custom(self, "sort_descending")
		for score in sorted:
			var new_score_panel = score_panel.instance()
			new_score_panel.name = str(score)
			new_score_panel.get_node("label_Score").text =  str(score)
			$UI2/Menu/Score/sc_Scores/GridContainer.add_child(new_score_panel)
			new_score_panel.visible = true
	$UI2/Menu/Score.visible = true

func  _on_btn_Achiev_pressed():
		
	for child in $UI2/Menu/Achiev/sc_Achiev/GridContainer.get_children():
			child.queue_free() 
			
	var achiev_panel = load("res://scenes/ui/achiev.tscn")
	
	for achiev in achievements:
		var new_achiev_panel = achiev_panel.instance()
		new_achiev_panel.name = str(achiev)
		if(achievements[achiev])==true:
			new_achiev_panel.get_node("label_Achiev").text =  str(all_achievements_description[achiev])
		else: new_achiev_panel.get_node("label_Achiev").text = "???"	
		$UI2/Menu/Achiev/sc_Achiev/GridContainer.add_child(new_achiev_panel)
		new_achiev_panel.visible = true
	$UI2/Menu/Achiev.visible = true
	
func unlocked_achievement():	
	if !achievements[unlocked_index]:
		achievements[unlocked_index]=true
		write_achiev()
		$Unlock_notification.visible = true
		yield(get_tree().create_timer(2.0), "timeout")
		$Unlock_notification.visible = false		
		
func add_new_achievements():
	for index in range(achievements.size(),all_achievements.size()):
		achievements[str(index)]=all_achievements[str(index)]
	write_achiev()	 	
		
func write_achiev():			
	var achiev_file = File.new()
	achiev_file.open("user://achiev.json", File.WRITE)
	achiev_file.store_line(to_json(achievements))
	
func _on_btn_Recipe_pressed():
	$UI2/Menu/Recipe.visible = true

func _on_btn_Back_pressed():
	$UI2/Menu/Score.visible = false
	$UI2/Menu/Recipe.visible = false
	$UI2/Menu/Achiev.visible = false
	

func _on_Timer_timeout():
	game_end()

func _on_btn_New_pressed():
	$UI2/GameEnd.visible = false
	$UI2/Menu.visible = false
	$UI.visible = true
	$Game.visible = true
	reset_game()

func _on_btn_Menu_pressed():
	back_to_menu()

func _on_btn_Resume_pressed():
	$UI2.visible = false
	$UI2/Pause.visible = false

func _on_cb_Classic_pressed():
	gamemode = "classic"
	$UI2/Menu/Recipe/Control/classic/cb_Classic.pressed = true
	$UI2/Menu/Recipe/Control/arcade/cb_Arcade.pressed = false
	$UI2/Menu/Recipe/Control/sandbox/cb_Sandbox.pressed = false

func _on_cb_Arcade_pressed():
	gamemode = "arcade"
	$UI2/Menu/Recipe/Control/classic/cb_Classic.pressed = false
	$UI2/Menu/Recipe/Control/arcade/cb_Arcade.pressed = true
	$UI2/Menu/Recipe/Control/sandbox/cb_Sandbox.pressed = false
