extends Control

onready var main = $"../.."

var moving = false
onready var walls = [get_node("../../Game/Box/Wall1"), get_node("../../Game/Box/Wall2")]
onready var guy = $Guy
var guy_default = preload("res://assets/sprites/objects/guy_default.png")
var guy_dropping = preload("res://assets/sprites/objects/guy_dropping.png")
var guy_blocked = preload("res://assets/sprites/objects/guy_blocked.png")

var next_destination = Vector2(250, 0)
const SMOOTH_SPEED = 10
var position_difference = Vector2()
var smoothed_velocity = Vector2()

onready var point = $Point
#levels below preloaded for testing purposes
onready var levels = [preload("res://scenes/objects/level1.tscn"), preload("res://scenes/objects/level2.tscn"), preload("res://scenes/objects/level3.tscn"), preload("res://scenes/objects/level4.tscn"), preload("res://scenes/objects/level5.tscn"), preload("res://scenes/objects/level6.tscn"), preload("res://scenes/objects/level7.tscn"), preload("res://scenes/objects/level8.tscn"), preload("res://scenes/objects/level9.tscn"), preload("res://scenes/objects/level10.tscn"), preload("res://scenes/objects/level11.tscn")]
onready var drops = $"../../Game/Drops"

func _ready():
	pass # Replace with function body.

func _on_Tap_button_down():
	guy.texture = guy_dropping
	moving = true

func _on_Tap_button_up():
	moving = false
	spawn()
	guy.texture = guy_default

func spawn():
	if $Point/Area2D.get_overlapping_bodies().size() == 0:
		var pos = point.rect_global_position
		var new = levels[main.next_drop-1].instance()
		new.position.x = pos.x
		drops.add_child(new)
		main.dropped()

func _physics_process(delta):
	if moving == true and get_global_mouse_position().x > 60 and get_global_mouse_position().x < 445:
		next_destination = get_global_mouse_position()
	position_difference = next_destination.x - rect_position.x
	smoothed_velocity = position_difference * SMOOTH_SPEED * delta
	rect_position.x += smoothed_velocity-(rect_size.x/12)
