/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.Verifier;
import org.xbill.DNS.security.DSASignature;
import org.xbill.DNS.security.KEYConverter;

public class DNSSECVerifier
implements Verifier {
    private Map trustedKeys = new HashMap();

    public synchronized void addTrustedKey(DNSKEYRecord dNSKEYRecord) {
        Name name = dNSKEYRecord.getName();
        LinkedList<DNSKEYRecord> linkedList = (LinkedList<DNSKEYRecord>)this.trustedKeys.get(name);
        if (linkedList == null) {
            linkedList = new LinkedList<DNSKEYRecord>();
            this.trustedKeys.put(name, linkedList);
        }
        linkedList.add(dNSKEYRecord);
    }

    public void addTrustedKey(Name name, int n, PublicKey publicKey) {
        Record record = KEYConverter.buildRecord(name, 48, 1, 0L, 0, 3, n, publicKey);
        if (record != null) {
            this.addTrustedKey((DNSKEYRecord)record);
        }
    }

    private PublicKey findMatchingKey(Iterator iterator, int n, int n2) {
        while (iterator.hasNext()) {
            DNSKEYRecord dNSKEYRecord = (DNSKEYRecord)iterator.next();
            if (dNSKEYRecord.getAlgorithm() != n || dNSKEYRecord.getFootprint() != n2) continue;
            return KEYConverter.parseRecord(dNSKEYRecord);
        }
        return null;
    }

    private synchronized PublicKey findTrustedKey(Name name, int n, int n2) {
        List list = (List)this.trustedKeys.get(name);
        if (list == null) {
            return null;
        }
        return this.findMatchingKey(list.iterator(), n, n2);
    }

    private PublicKey findCachedKey(Cache cache, Name name, int n, int n2) {
        RRset[] rRsetArray = cache.findAnyRecords(name, 48);
        if (rRsetArray == null) {
            return null;
        }
        RRset rRset = rRsetArray[0];
        return this.findMatchingKey(rRset.rrs(), n, n2);
    }

    private PublicKey findKey(Cache cache, Name name, int n, int n2) {
        PublicKey publicKey = this.findTrustedKey(name, n, n2);
        if (publicKey == null && cache != null) {
            return this.findCachedKey(cache, name, n, n2);
        }
        return publicKey;
    }

    private int verifySIG(RRset rRset, RRSIGRecord rRSIGRecord, Cache cache) {
        String string;
        byte[] byArray;
        PublicKey publicKey = this.findKey(cache, rRSIGRecord.getSigner(), rRSIGRecord.getAlgorithm(), rRSIGRecord.getFootprint());
        if (publicKey == null) {
            return 0;
        }
        Date date = new Date();
        if (date.compareTo(rRSIGRecord.getExpire()) > 0 || date.compareTo(rRSIGRecord.getTimeSigned()) < 0) {
            System.err.println("Outside of validity period");
            return -1;
        }
        byte[] byArray2 = DNSSEC.digestRRset(rRSIGRecord, rRset);
        switch (rRSIGRecord.getAlgorithm()) {
            case 1: {
                byArray = rRSIGRecord.getSignature();
                string = "MD5withRSA";
                break;
            }
            case 3: 
            case 6: {
                byArray = DSASignature.fromDNS(rRSIGRecord.getSignature());
                string = "SHA1withDSA";
                break;
            }
            case 5: 
            case 7: {
                byArray = rRSIGRecord.getSignature();
                string = "SHA1withRSA";
                break;
            }
            case 8: {
                byArray = rRSIGRecord.getSignature();
                string = "SHA256withRSA";
                break;
            }
            case 10: {
                byArray = rRSIGRecord.getSignature();
                string = "SHA512withRSA";
                break;
            }
            default: {
                return -1;
            }
        }
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            signature.update(byArray2);
            return signature.verify(byArray) ? 1 : -1;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Signing data: " + generalSecurityException);
            }
            return -1;
        }
    }

    @Override
    public int verify(RRset rRset, Cache cache) {
        Iterator iterator = rRset.sigs();
        if (Options.check("verbosesec")) {
            System.out.print("Verifying " + rRset.getName() + "/" + Type.string(rRset.getType()) + ": ");
        }
        if (!iterator.hasNext()) {
            if (Options.check("verbosesec")) {
                System.out.println("Insecure");
            }
            return 0;
        }
        while (iterator.hasNext()) {
            RRSIGRecord rRSIGRecord = (RRSIGRecord)iterator.next();
            if (this.verifySIG(rRset, rRSIGRecord, cache) != 1) continue;
            if (Options.check("verbosesec")) {
                System.out.println("Secure");
            }
            return 1;
        }
        if (Options.check("verbosesec")) {
            System.out.println("Failed");
        }
        return -1;
    }
}

