/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.TypeBitmap;
import org.xbill.DNS.utils.base16;
import org.xbill.DNS.utils.base32;

public class NSEC3Record
extends Record {
    public static final byte SHA1_DIGEST_ID = 1;
    private static final long serialVersionUID = -7123504635968932855L;
    private int hashAlg;
    private int flags;
    private int iterations;
    private byte[] salt;
    private byte[] next;
    private TypeBitmap types;
    private static final base32 b32 = new base32("0123456789ABCDEFGHIJKLMNOPQRSTUV=", false, false);

    NSEC3Record() {
    }

    @Override
    Record getObject() {
        return new NSEC3Record();
    }

    public NSEC3Record(Name name, int n, long l, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, int[] nArray) {
        super(name, 50, n, l);
        this.hashAlg = NSEC3Record.checkU8("hashAlg", n2);
        this.flags = NSEC3Record.checkU8("flags", n3);
        this.iterations = NSEC3Record.checkU16("iterations", n4);
        if (byArray != null) {
            if (byArray.length > 255) {
                throw new IllegalArgumentException("Invalid salt");
            }
            if (byArray.length > 0) {
                this.salt = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
            }
        }
        if (byArray2.length > 255) {
            throw new IllegalArgumentException("Invalid next hash");
        }
        this.next = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.next, 0, byArray2.length);
        this.types = new TypeBitmap(nArray);
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.hashAlg = dNSInput.readU8();
        this.flags = dNSInput.readU8();
        this.iterations = dNSInput.readU16();
        int n = dNSInput.readU8();
        this.salt = (byte[])(n > 0 ? dNSInput.readByteArray(n) : null);
        int n2 = dNSInput.readU8();
        this.next = dNSInput.readByteArray(n2);
        this.types = new TypeBitmap(dNSInput);
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU8(this.hashAlg);
        dNSOutput.writeU8(this.flags);
        dNSOutput.writeU16(this.iterations);
        if (this.salt != null) {
            dNSOutput.writeU8(this.salt.length);
            dNSOutput.writeByteArray(this.salt);
        } else {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeU8(this.next.length);
        dNSOutput.writeByteArray(this.next);
        this.types.toWire(dNSOutput);
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.hashAlg = tokenizer.getUInt8();
        this.flags = tokenizer.getUInt8();
        this.iterations = tokenizer.getUInt16();
        String string = tokenizer.getString();
        if (string.equals("-")) {
            this.salt = null;
        } else {
            tokenizer.unget();
            this.salt = tokenizer.getHexString();
            if (this.salt.length > 255) {
                throw tokenizer.exception("salt value too long");
            }
        }
        this.next = tokenizer.getBase32String(b32);
        this.types = new TypeBitmap(tokenizer);
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hashAlg);
        stringBuffer.append(' ');
        stringBuffer.append(this.flags);
        stringBuffer.append(' ');
        stringBuffer.append(this.iterations);
        stringBuffer.append(' ');
        if (this.salt == null) {
            stringBuffer.append('-');
        } else {
            stringBuffer.append(base16.toString(this.salt));
        }
        stringBuffer.append(' ');
        stringBuffer.append(b32.toString(this.next));
        if (!this.types.empty()) {
            stringBuffer.append(' ');
            stringBuffer.append(this.types.toString());
        }
        return stringBuffer.toString();
    }

    public int getHashAlgorithm() {
        return this.hashAlg;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getIterations() {
        return this.iterations;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getNext() {
        return this.next;
    }

    public int[] getTypes() {
        return this.types.toArray();
    }

    public boolean hasType(int n) {
        return this.types.contains(n);
    }

    static byte[] hashName(Name name, int n, int n2, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest;
        switch (n) {
            case 1: {
                messageDigest = MessageDigest.getInstance("sha-1");
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Unknown NSEC3 algorithmidentifier: " + n);
            }
        }
        byte[] byArray2 = null;
        for (int i = 0; i <= n2; ++i) {
            messageDigest.reset();
            if (i == 0) {
                messageDigest.update(name.toWireCanonical());
            } else {
                messageDigest.update(byArray2);
            }
            if (byArray != null) {
                messageDigest.update(byArray);
            }
            byArray2 = messageDigest.digest();
        }
        return byArray2;
    }

    public byte[] hashName(Name name) throws NoSuchAlgorithmException {
        return NSEC3Record.hashName(name, this.hashAlg, this.iterations, this.salt);
    }

    public static class Flags {
        public static final int OPT_OUT = 1;

        private Flags() {
        }
    }
}

