/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.base64;

abstract class KEYBase
extends Record {
    private static final long serialVersionUID = 3469321722693285454L;
    protected int flags;
    protected int proto;
    protected int alg;
    protected byte[] key;
    protected int footprint = -1;

    protected KEYBase() {
    }

    public KEYBase(Name name, int n, int n2, long l, int n3, int n4, int n5, byte[] byArray) {
        super(name, n, n2, l);
        this.flags = KEYBase.checkU16("flags", n3);
        this.proto = KEYBase.checkU8("proto", n4);
        this.alg = KEYBase.checkU8("alg", n5);
        this.key = byArray;
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.flags = dNSInput.readU16();
        this.proto = dNSInput.readU8();
        this.alg = dNSInput.readU8();
        if (dNSInput.remaining() > 0) {
            this.key = dNSInput.readByteArray();
        }
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.flags);
        stringBuffer.append(" ");
        stringBuffer.append(this.proto);
        stringBuffer.append(" ");
        stringBuffer.append(this.alg);
        if (this.key != null) {
            if (Options.check("multiline")) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString(this.key, 64, "\t", true));
                stringBuffer.append(" ; key_tag = ");
                stringBuffer.append(this.getFootprint());
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(base64.toString(this.key));
            }
        }
        return stringBuffer.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getProtocol() {
        return this.proto;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getFootprint() {
        if (this.footprint >= 0) {
            return this.footprint;
        }
        int n = 0;
        DNSOutput dNSOutput = new DNSOutput();
        this.rrToWire(dNSOutput, null, false);
        byte[] byArray = dNSOutput.toByteArray();
        if (this.alg == 1) {
            int n2 = byArray[byArray.length - 3] & 0xFF;
            int n3 = byArray[byArray.length - 2] & 0xFF;
            n = (n2 << 8) + n3;
        } else {
            int n4;
            int n5;
            for (n5 = 0; n5 < byArray.length - 1; n5 += 2) {
                n4 = byArray[n5] & 0xFF;
                int n6 = byArray[n5 + 1] & 0xFF;
                n += (n4 << 8) + n6;
            }
            if (n5 < byArray.length) {
                n4 = byArray[n5] & 0xFF;
                n += n4 << 8;
            }
            n += n >> 16 & 0xFFFF;
        }
        this.footprint = n & 0xFFFF;
        return this.footprint;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.flags);
        dNSOutput.writeU8(this.proto);
        dNSOutput.writeU8(this.alg);
        if (this.key != null) {
            dNSOutput.writeByteArray(this.key);
        }
    }
}

