/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.ext.forms.WorkgroupForm;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.QueueUpdate;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.jivesoftware.smackx.workgroup.settings.ChatSetting;
import org.jivesoftware.smackx.workgroup.settings.ChatSettings;
import org.jivesoftware.smackx.workgroup.settings.OfflineSettings;
import org.jivesoftware.smackx.workgroup.settings.SoundSettings;
import org.jivesoftware.smackx.workgroup.settings.WorkgroupProperties;
import org.jivesoftware.smackx.workgroup.user.QueueListener;

public class Workgroup {
    private String workgroupJID;
    private XMPPConnection connection;
    private boolean inQueue;
    private List invitationListeners;
    private List queueListeners;
    private List siteInviteListeners;
    private int queuePosition = -1;
    private int queueRemainingTime = -1;

    public Workgroup(String string, XMPPConnection xMPPConnection) {
        if (!xMPPConnection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = string;
        this.connection = xMPPConnection;
        this.inQueue = false;
        this.invitationListeners = new ArrayList();
        this.queueListeners = new ArrayList();
        this.siteInviteListeners = new ArrayList();
        this.addQueueListener(new QueueListener(){

            @Override
            public void joinedQueue() {
                Workgroup.this.inQueue = true;
            }

            @Override
            public void departedQueue() {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }

            @Override
            public void queuePositionUpdated(int n) {
                Workgroup.this.queuePosition = n;
            }

            @Override
            public void queueWaitTimeUpdated(int n) {
                Workgroup.this.queueRemainingTime = n;
            }
        });
        MultiUserChat.addInvitationListener(xMPPConnection, new InvitationListener(){

            @Override
            public void invitationReceived(XMPPConnection xMPPConnection, String string, String string2, String string3, String string4, Message message) {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }
        });
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(Message.class);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Workgroup.this.handlePacket(packet);
            }
        }, packetTypeFilter);
    }

    public String getWorkgroupJID() {
        return this.workgroupJID;
    }

    public boolean isInQueue() {
        return this.inQueue;
    }

    public boolean isAvailable() {
        Presence presence = new Presence(Presence.Type.available);
        presence.setTo(this.workgroupJID);
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(Presence.class);
        FromContainsFilter fromContainsFilter = new FromContainsFilter(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new AndFilter(fromContainsFilter, packetTypeFilter));
        this.connection.sendPacket(presence);
        Presence presence2 = (Presence)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (presence2 == null) {
            return false;
        }
        if (presence2.getError() != null) {
            return false;
        }
        return Presence.Type.available == presence2.getType();
    }

    public int getQueuePosition() {
        return this.queuePosition;
    }

    public int getQueueRemainingTime() {
        return this.queueRemainingTime;
    }

    public void joinQueue() throws XMPPException {
        this.joinQueue(null);
    }

    public void joinQueue(Form form) throws XMPPException {
        this.joinQueue(form, null);
    }

    public void joinQueue(Form form, String string) throws XMPPException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + this.workgroupJID);
        }
        JoinQueuePacket joinQueuePacket = new JoinQueuePacket(this.workgroupJID, form, string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(joinQueuePacket.getPacketID()));
        this.connection.sendPacket(joinQueuePacket);
        IQ iQ = (IQ)packetCollector.nextResult(10000L);
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        this.fireQueueJoinedEvent();
    }

    public void joinQueue(Map map, String string) throws XMPPException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + this.workgroupJID);
        }
        Form form = new Form("submit");
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2).toString();
            String string4 = StringUtils.escapeForXML(string2);
            String string5 = StringUtils.escapeForXML(string3);
            FormField formField = new FormField(string4);
            formField.setType("text-single");
            form.addField(formField);
            form.setAnswer(string4, string5);
        }
        this.joinQueue(form, string);
    }

    public void departQueue() throws XMPPException {
        if (!this.inQueue) {
            return;
        }
        DepartQueuePacket departQueuePacket = new DepartQueuePacket(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(departQueuePacket.getPacketID()));
        this.connection.sendPacket(departQueuePacket);
        IQ iQ = (IQ)packetCollector.nextResult(5000L);
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        this.fireQueueDepartedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueListener(QueueListener queueListener) {
        List list = this.queueListeners;
        synchronized (list) {
            if (!this.queueListeners.contains(queueListener)) {
                this.queueListeners.add(queueListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(QueueListener queueListener) {
        List list = this.queueListeners;
        synchronized (list) {
            this.queueListeners.remove(queueListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WorkgroupInvitationListener workgroupInvitationListener) {
        List list = this.invitationListeners;
        synchronized (list) {
            if (!this.invitationListeners.contains(workgroupInvitationListener)) {
                this.invitationListeners.add(workgroupInvitationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(WorkgroupInvitationListener workgroupInvitationListener) {
        List list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(workgroupInvitationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationEvent(WorkgroupInvitation workgroupInvitation) {
        List list = this.invitationListeners;
        synchronized (list) {
            for (WorkgroupInvitationListener workgroupInvitationListener : this.invitationListeners) {
                workgroupInvitationListener.invitationReceived(workgroupInvitation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueJoinedEvent() {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener queueListener : this.queueListeners) {
                queueListener.joinedQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueDepartedEvent() {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener queueListener : this.queueListeners) {
                queueListener.departedQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueuePositionEvent(int n) {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener queueListener : this.queueListeners) {
                queueListener.queuePositionUpdated(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueTimeEvent(int n) {
        List list = this.queueListeners;
        synchronized (list) {
            for (QueueListener queueListener : this.queueListeners) {
                queueListener.queueWaitTimeUpdated(n);
            }
        }
    }

    private void handlePacket(Packet packet) {
        if (packet instanceof Message) {
            Message message = (Message)packet;
            PacketExtension packetExtension = message.getExtension("depart-queue", "http://jabber.org/protocol/workgroup");
            PacketExtension packetExtension2 = message.getExtension("queue-status", "http://jabber.org/protocol/workgroup");
            if (packetExtension != null) {
                this.fireQueueDepartedEvent();
            } else if (packetExtension2 != null) {
                QueueUpdate queueUpdate = (QueueUpdate)packetExtension2;
                if (queueUpdate.getPosition() != -1) {
                    this.fireQueuePositionEvent(queueUpdate.getPosition());
                }
                if (queueUpdate.getRemaingTime() != -1) {
                    this.fireQueueTimeEvent(queueUpdate.getRemaingTime());
                }
            } else {
                MUCUser.Invite invite;
                MUCUser mUCUser = (MUCUser)message.getExtension("x", "http://jabber.org/protocol/muc#user");
                MUCUser.Invite invite2 = invite = mUCUser != null ? mUCUser.getInvite() : null;
                if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                    String string = null;
                    Map map = null;
                    packetExtension = message.getExtension("session", "http://jivesoftware.com/protocol/workgroup");
                    if (packetExtension != null) {
                        string = ((SessionID)packetExtension).getSessionID();
                    }
                    if ((packetExtension = message.getExtension("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                        map = ((MetaData)packetExtension).getMetaData();
                    }
                    WorkgroupInvitation workgroupInvitation = new WorkgroupInvitation(this.connection.getUser(), message.getFrom(), this.workgroupJID, string, message.getBody(), message.getFrom(), map);
                    this.fireInvitationEvent(workgroupInvitation);
                }
            }
        }
    }

    public ChatSetting getChatSetting(String string) throws XMPPException {
        ChatSettings chatSettings = this.getChatSettings(string, -1);
        return chatSettings.getFirstEntry();
    }

    public ChatSettings getChatSettings(int n) throws XMPPException {
        return this.getChatSettings(null, n);
    }

    public ChatSettings getChatSettings() throws XMPPException {
        return this.getChatSettings(null, -1);
    }

    private ChatSettings getChatSettings(String string, int n) throws XMPPException {
        ChatSettings chatSettings = new ChatSettings();
        if (string != null) {
            chatSettings.setKey(string);
        }
        if (n != -1) {
            chatSettings.setType(n);
        }
        chatSettings.setType(IQ.Type.GET);
        chatSettings.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(chatSettings.getPacketID()));
        this.connection.sendPacket(chatSettings);
        ChatSettings chatSettings2 = (ChatSettings)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (chatSettings2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (chatSettings2.getError() != null) {
            throw new XMPPException(chatSettings2.getError());
        }
        return chatSettings2;
    }

    public boolean isEmailAvailable() {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.connection);
        try {
            String string = StringUtils.parseServer(this.workgroupJID);
            DiscoverInfo discoverInfo = serviceDiscoveryManager.discoverInfo(string);
            return discoverInfo.containsFeature("jive:email:provider");
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }

    public OfflineSettings getOfflineSettings() throws XMPPException {
        OfflineSettings offlineSettings = new OfflineSettings();
        offlineSettings.setType(IQ.Type.GET);
        offlineSettings.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(offlineSettings.getPacketID()));
        this.connection.sendPacket(offlineSettings);
        OfflineSettings offlineSettings2 = (OfflineSettings)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (offlineSettings2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (offlineSettings2.getError() != null) {
            throw new XMPPException(offlineSettings2.getError());
        }
        return offlineSettings2;
    }

    public SoundSettings getSoundSettings() throws XMPPException {
        SoundSettings soundSettings = new SoundSettings();
        soundSettings.setType(IQ.Type.GET);
        soundSettings.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(soundSettings.getPacketID()));
        this.connection.sendPacket(soundSettings);
        SoundSettings soundSettings2 = (SoundSettings)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (soundSettings2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (soundSettings2.getError() != null) {
            throw new XMPPException(soundSettings2.getError());
        }
        return soundSettings2;
    }

    public WorkgroupProperties getWorkgroupProperties() throws XMPPException {
        WorkgroupProperties workgroupProperties = new WorkgroupProperties();
        workgroupProperties.setType(IQ.Type.GET);
        workgroupProperties.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(workgroupProperties.getPacketID()));
        this.connection.sendPacket(workgroupProperties);
        WorkgroupProperties workgroupProperties2 = (WorkgroupProperties)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (workgroupProperties2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (workgroupProperties2.getError() != null) {
            throw new XMPPException(workgroupProperties2.getError());
        }
        return workgroupProperties2;
    }

    public WorkgroupProperties getWorkgroupProperties(String string) throws XMPPException {
        WorkgroupProperties workgroupProperties = new WorkgroupProperties();
        workgroupProperties.setJid(string);
        workgroupProperties.setType(IQ.Type.GET);
        workgroupProperties.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(workgroupProperties.getPacketID()));
        this.connection.sendPacket(workgroupProperties);
        WorkgroupProperties workgroupProperties2 = (WorkgroupProperties)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (workgroupProperties2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (workgroupProperties2.getError() != null) {
            throw new XMPPException(workgroupProperties2.getError());
        }
        return workgroupProperties2;
    }

    public Form getWorkgroupForm() throws XMPPException {
        WorkgroupForm workgroupForm = new WorkgroupForm();
        workgroupForm.setType(IQ.Type.GET);
        workgroupForm.setTo(this.workgroupJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(workgroupForm.getPacketID()));
        this.connection.sendPacket(workgroupForm);
        WorkgroupForm workgroupForm2 = (WorkgroupForm)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (workgroupForm2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (workgroupForm2.getError() != null) {
            throw new XMPPException(workgroupForm2.getError());
        }
        return Form.getFormFrom(workgroupForm2);
    }

    private class JoinQueuePacket
    extends IQ {
        private String userID = null;
        private DataForm form;

        public JoinQueuePacket(String string, Form form, String string2) {
            this.userID = string2;
            this.setTo(string);
            this.setType(IQ.Type.SET);
            this.form = form.getDataFormToSend();
            this.addExtension(this.form);
        }

        @Override
        public String getChildElementXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<join-queue xmlns=\"http://jabber.org/protocol/workgroup\">");
            stringBuilder.append("<queue-notifications/>");
            if (Workgroup.this.connection.isAnonymous()) {
                stringBuilder.append(new UserID(this.userID).toXML());
            }
            stringBuilder.append(this.form.toXML());
            stringBuilder.append("</join-queue>");
            return stringBuilder.toString();
        }
    }
}

