/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.workgroup.agent.WorkgroupQueue;
import org.xmlpull.v1.XmlPullParser;

public class QueueOverview
implements PacketExtension {
    public static String ELEMENT_NAME = "notify-queue";
    public static String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private int averageWaitTime = -1;
    private Date oldestEntry = null;
    private int userCount = -1;
    private WorkgroupQueue.Status status = null;

    QueueOverview() {
    }

    void setAverageWaitTime(int n) {
        this.averageWaitTime = n;
    }

    public int getAverageWaitTime() {
        return this.averageWaitTime;
    }

    void setOldestEntry(Date date) {
        this.oldestEntry = date;
    }

    public Date getOldestEntry() {
        return this.oldestEntry;
    }

    void setUserCount(int n) {
        this.userCount = n;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public WorkgroupQueue.Status getStatus() {
        return this.status;
    }

    void setStatus(WorkgroupQueue.Status status) {
        this.status = status;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        if (this.userCount != -1) {
            stringBuilder.append("<count>").append(this.userCount).append("</count>");
        }
        if (this.oldestEntry != null) {
            stringBuilder.append("<oldest>").append(DATE_FORMATTER.format(this.oldestEntry)).append("</oldest>");
        }
        if (this.averageWaitTime != -1) {
            stringBuilder.append("<time>").append(this.averageWaitTime).append("</time>");
        }
        if (this.status != null) {
            stringBuilder.append("<status>").append(this.status).append("</status>");
        }
        stringBuilder.append("</").append(ELEMENT_NAME).append(">");
        return stringBuilder.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            int n = xmlPullParser.getEventType();
            QueueOverview queueOverview = new QueueOverview();
            if (n != 2) {
                // empty if block
            }
            n = xmlPullParser.next();
            while (n != 3 || !ELEMENT_NAME.equals(xmlPullParser.getName())) {
                if ("count".equals(xmlPullParser.getName())) {
                    queueOverview.setUserCount(Integer.parseInt(xmlPullParser.nextText()));
                } else if ("time".equals(xmlPullParser.getName())) {
                    queueOverview.setAverageWaitTime(Integer.parseInt(xmlPullParser.nextText()));
                } else if ("oldest".equals(xmlPullParser.getName())) {
                    queueOverview.setOldestEntry(DATE_FORMATTER.parse(xmlPullParser.nextText()));
                } else if ("status".equals(xmlPullParser.getName())) {
                    queueOverview.setStatus(WorkgroupQueue.Status.fromString(xmlPullParser.nextText()));
                }
                if ((n = xmlPullParser.next()) == 3) continue;
            }
            if (n != 3) {
                // empty if block
            }
            return queueOverview;
        }
    }
}

