/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.workgroup.QueueUser;
import org.xmlpull.v1.XmlPullParser;

public class QueueDetails
implements PacketExtension {
    public static final String ELEMENT_NAME = "notify-queue-details";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private Set<QueueUser> users = new HashSet<QueueUser>();

    private QueueDetails() {
    }

    public int getUserCount() {
        return this.users.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<QueueUser> getUsers() {
        Set<QueueUser> set = this.users;
        synchronized (set) {
            return this.users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUser(QueueUser queueUser) {
        Set<QueueUser> set = this.users;
        synchronized (set) {
            this.users.add(queueUser);
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        Set<QueueUser> set = this.users;
        synchronized (set) {
            for (QueueUser queueUser : this.users) {
                int n = queueUser.getQueuePosition();
                int n2 = queueUser.getEstimatedRemainingTime();
                Date date = queueUser.getQueueJoinTimestamp();
                stringBuilder.append("<user jid=\"").append(queueUser.getUserID()).append("\">");
                if (n != -1) {
                    stringBuilder.append("<position>").append(n).append("</position>");
                }
                if (n2 != -1) {
                    stringBuilder.append("<time>").append(n2).append("</time>");
                }
                if (date != null) {
                    stringBuilder.append("<join-time>");
                    stringBuilder.append(DATE_FORMATTER.format(date));
                    stringBuilder.append("</join-time>");
                }
                stringBuilder.append("</user>");
            }
        }
        stringBuilder.append("</").append(ELEMENT_NAME).append(">");
        return stringBuilder.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            QueueDetails queueDetails = new QueueDetails();
            int n = xmlPullParser.getEventType();
            while (n != 3 && QueueDetails.ELEMENT_NAME.equals(xmlPullParser.getName())) {
                n = xmlPullParser.next();
                while (n == 2 && "user".equals(xmlPullParser.getName())) {
                    String string = null;
                    int n2 = -1;
                    int n3 = -1;
                    Date date = null;
                    string = xmlPullParser.getAttributeValue("", "jid");
                    if (string == null) {
                        // empty if block
                    }
                    n = xmlPullParser.next();
                    while (n != 3 || !"user".equals(xmlPullParser.getName())) {
                        if ("position".equals(xmlPullParser.getName())) {
                            n2 = Integer.parseInt(xmlPullParser.nextText());
                        } else if ("time".equals(xmlPullParser.getName())) {
                            n3 = Integer.parseInt(xmlPullParser.nextText());
                        } else if ("join-time".equals(xmlPullParser.getName())) {
                            date = DATE_FORMATTER.parse(xmlPullParser.nextText());
                        } else if (xmlPullParser.getName().equals("waitTime")) {
                            Date date2 = DATE_FORMATTER.parse(xmlPullParser.nextText());
                            System.out.println(date2);
                        }
                        if ((n = xmlPullParser.next()) == 3) continue;
                    }
                    queueDetails.addUser(new QueueUser(string, n2, n3, date));
                    n = xmlPullParser.next();
                }
            }
            return queueDetails;
        }
    }
}

