/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.xmlpull.v1.XmlPullParser;

public class UserSearch
extends IQ {
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:search\">");
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    public Form getSearchForm(XMPPConnection xMPPConnection, String string) throws XMPPException {
        UserSearch userSearch = new UserSearch();
        userSearch.setType(IQ.Type.GET);
        userSearch.setTo(string);
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(userSearch.getPacketID()));
        xMPPConnection.sendPacket(userSearch);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        return Form.getFormFrom(iQ);
    }

    public ReportedData sendSearchForm(XMPPConnection xMPPConnection, Form form, String string) throws XMPPException {
        UserSearch userSearch = new UserSearch();
        userSearch.setType(IQ.Type.SET);
        userSearch.setTo(string);
        userSearch.addExtension(form.getDataFormToSend());
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(userSearch.getPacketID()));
        xMPPConnection.sendPacket(userSearch);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (iQ.getError() != null) {
            return this.sendSimpleSearchForm(xMPPConnection, form, string);
        }
        return ReportedData.getReportedDataFrom(iQ);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection xMPPConnection, Form form, String string) throws XMPPException {
        SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
        simpleUserSearch.setForm(form);
        simpleUserSearch.setType(IQ.Type.SET);
        simpleUserSearch.setTo(string);
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(simpleUserSearch.getPacketID()));
        xMPPConnection.sendPacket(simpleUserSearch);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        if (iQ instanceof SimpleUserSearch) {
            return ((SimpleUserSearch)iQ).getReportedData();
        }
        return null;
    }

    private static void buildDataForm(SimpleUserSearch simpleUserSearch, String string, XmlPullParser xmlPullParser) throws Exception {
        DataForm dataForm = new DataForm("form");
        boolean bl = false;
        dataForm.setTitle("User Search");
        dataForm.addInstruction(string);
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2 && !xmlPullParser.getNamespace().equals("jabber:x:data")) {
                String string2 = xmlPullParser.getName();
                FormField formField = new FormField(string2);
                if (string2.equals("first")) {
                    formField.setLabel("First Name");
                } else if (string2.equals("last")) {
                    formField.setLabel("Last Name");
                } else if (string2.equals("email")) {
                    formField.setLabel("Email Address");
                } else if (string2.equals("nick")) {
                    formField.setLabel("Nickname");
                }
                formField.setType("text-single");
                dataForm.addField(formField);
                continue;
            }
            if (n == 3) {
                if (!xmlPullParser.getName().equals("query")) continue;
                bl = true;
                continue;
            }
            if (n != 2 || !xmlPullParser.getNamespace().equals("jabber:x:data")) continue;
            simpleUserSearch.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
            bl = true;
        }
        if (simpleUserSearch.getExtension("x", "jabber:x:data") == null) {
            simpleUserSearch.addExtension(dataForm);
        }
    }

    public static class Provider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            UserSearch userSearch = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && xmlPullParser.getName().equals("instructions")) {
                    UserSearch.buildDataForm(simpleUserSearch, xmlPullParser.nextText(), xmlPullParser);
                    return simpleUserSearch;
                }
                if (n == 2 && xmlPullParser.getName().equals("item")) {
                    simpleUserSearch.parseItems(xmlPullParser);
                    return simpleUserSearch;
                }
                if (n == 2 && xmlPullParser.getNamespace().equals("jabber:x:data")) {
                    userSearch = new UserSearch();
                    userSearch.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
                bl = true;
            }
            if (userSearch != null) {
                return userSearch;
            }
            return simpleUserSearch;
        }
    }
}

