/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.xmlpull.v1.XmlPullParser;

public class DelayInformationProvider
implements PacketExtensionProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        Object object;
        Date date = null;
        try {
            object = DelayInformation.UTC_FORMAT;
            synchronized (object) {
                date = DelayInformation.UTC_FORMAT.parse(xmlPullParser.getAttributeValue("", "stamp"));
            }
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat = DelayInformation.NEW_UTC_FORMAT;
                synchronized (simpleDateFormat) {
                    date = DelayInformation.NEW_UTC_FORMAT.parse(xmlPullParser.getAttributeValue("", "stamp"));
                }
            }
            catch (ParseException parseException2) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                date = simpleDateFormat.parse(xmlPullParser.getAttributeValue("", "stamp"));
            }
        }
        object = new DelayInformation(date);
        ((DelayInformation)object).setFrom(xmlPullParser.getAttributeValue("", "from"));
        ((DelayInformation)object).setReason(xmlPullParser.nextText());
        return object;
    }
}

