/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class VCard
extends IQ {
    private Map<String, String> homePhones = new HashMap<String, String>();
    private Map<String, String> workPhones = new HashMap<String, String>();
    private Map<String, String> homeAddr = new HashMap<String, String>();
    private Map<String, String> workAddr = new HashMap<String, String>();
    private String firstName;
    private String lastName;
    private String middleName;
    private String emailHome;
    private String emailWork;
    private String organization;
    private String organizationUnit;
    private String avatar;
    private Map<String, String> otherSimpleFields = new HashMap<String, String>();
    private Map<String, String> otherUnescapableFields = new HashMap<String, String>();

    public String getField(String string) {
        return this.otherSimpleFields.get(string);
    }

    public void setField(String string, String string2) {
        this.setField(string, string2, false);
    }

    public void setField(String string, String string2, boolean bl) {
        if (!bl) {
            this.otherSimpleFields.put(string, string2);
        } else {
            this.otherUnescapableFields.put(string, string2);
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String string) {
        this.firstName = string;
        this.updateFN();
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String string) {
        this.lastName = string;
        this.updateFN();
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String string) {
        this.middleName = string;
        this.updateFN();
    }

    public String getNickName() {
        return this.otherSimpleFields.get("NICKNAME");
    }

    public void setNickName(String string) {
        this.otherSimpleFields.put("NICKNAME", string);
    }

    public String getEmailHome() {
        return this.emailHome;
    }

    public void setEmailHome(String string) {
        this.emailHome = string;
    }

    public String getEmailWork() {
        return this.emailWork;
    }

    public void setEmailWork(String string) {
        this.emailWork = string;
    }

    public String getJabberId() {
        return this.otherSimpleFields.get("JABBERID");
    }

    public void setJabberId(String string) {
        this.otherSimpleFields.put("JABBERID", string);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String string) {
        this.organization = string;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String string) {
        this.organizationUnit = string;
    }

    public String getAddressFieldHome(String string) {
        return this.homeAddr.get(string);
    }

    public void setAddressFieldHome(String string, String string2) {
        this.homeAddr.put(string, string2);
    }

    public String getAddressFieldWork(String string) {
        return this.workAddr.get(string);
    }

    public void setAddressFieldWork(String string, String string2) {
        this.workAddr.put(string, string2);
    }

    public void setPhoneHome(String string, String string2) {
        this.homePhones.put(string, string2);
    }

    public String getPhoneHome(String string) {
        return this.homePhones.get(string);
    }

    public void setPhoneWork(String string, String string2) {
        this.workPhones.put(string, string2);
    }

    public String getPhoneWork(String string) {
        return this.workPhones.get(string);
    }

    public void setAvatar(URL uRL) {
        byte[] byArray = new byte[]{};
        try {
            byArray = VCard.getBytes(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setAvatar(byArray);
    }

    public void setAvatar(byte[] byArray) {
        String string;
        if (byArray == null) {
            this.otherUnescapableFields.remove("PHOTO");
            return;
        }
        this.avatar = string = StringUtils.encodeBase64(byArray);
        this.setField("PHOTO", "<TYPE>image/jpeg</TYPE><BINVAL>" + string + "</BINVAL>", true);
    }

    public void setAvatar(byte[] byArray, String string) {
        String string2;
        if (byArray == null) {
            this.otherUnescapableFields.remove("PHOTO");
            return;
        }
        this.avatar = string2 = StringUtils.encodeBase64(byArray);
        this.setField("PHOTO", "<TYPE>" + string + "</TYPE><BINVAL>" + string2 + "</BINVAL>", true);
    }

    public void setEncodedImage(String string) {
        this.avatar = string;
    }

    public byte[] getAvatar() {
        if (this.avatar == null) {
            return null;
        }
        return StringUtils.decodeBase64(this.avatar);
    }

    public static byte[] getBytes(URL uRL) throws IOException {
        String string = uRL.getPath();
        File file = new File(string);
        if (file.exists()) {
            return VCard.getFileBytes(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytes(File file) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            int n2 = bufferedInputStream.read(byArray);
            if (n2 != byArray.length) {
                throw new IOException("Entire file not read");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public String getAvatarHash() {
        MessageDigest messageDigest;
        byte[] byArray = this.getAvatar();
        if (byArray == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        messageDigest.update(byArray);
        return StringUtils.encodeHex(messageDigest.digest());
    }

    private void updateFN() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.firstName != null) {
            stringBuilder.append(StringUtils.escapeForXML(this.firstName)).append(' ');
        }
        if (this.middleName != null) {
            stringBuilder.append(StringUtils.escapeForXML(this.middleName)).append(' ');
        }
        if (this.lastName != null) {
            stringBuilder.append(StringUtils.escapeForXML(this.lastName));
        }
        this.setField("FN", stringBuilder.toString());
    }

    public void save(XMPPConnection xMPPConnection) throws XMPPException {
        this.checkAuthenticated(xMPPConnection, true);
        this.setType(IQ.Type.SET);
        this.setFrom(xMPPConnection.getUser());
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(this.getPacketID()));
        xMPPConnection.sendPacket(this);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (packet.getError() != null) {
            throw new XMPPException(packet.getError());
        }
    }

    public void load(XMPPConnection xMPPConnection) throws XMPPException {
        this.checkAuthenticated(xMPPConnection, true);
        this.setFrom(xMPPConnection.getUser());
        this.doLoad(xMPPConnection, xMPPConnection.getUser());
    }

    public void load(XMPPConnection xMPPConnection, String string) throws XMPPException {
        this.checkAuthenticated(xMPPConnection, false);
        this.setTo(string);
        this.doLoad(xMPPConnection, string);
    }

    private void doLoad(XMPPConnection xMPPConnection, String string) throws XMPPException {
        this.setType(IQ.Type.GET);
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(this.getPacketID()));
        xMPPConnection.sendPacket(this);
        VCard vCard = null;
        try {
            vCard = (VCard)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            if (vCard == null) {
                String string2 = "Timeout getting VCard information";
                throw new XMPPException(string2, new XMPPError(XMPPError.Condition.request_timeout, string2));
            }
            if (vCard.getError() != null) {
                throw new XMPPException(vCard.getError());
            }
        }
        catch (ClassCastException classCastException) {
            System.out.println("No VCard for " + string);
        }
        this.copyFieldsFrom(vCard);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        new VCardWriter(stringBuilder).write();
        return stringBuilder.toString();
    }

    private void copyFieldsFrom(VCard vCard) {
        Field[] fieldArray;
        if (vCard == null) {
            vCard = new VCard();
        }
        for (Field field : fieldArray = VCard.class.getDeclaredFields()) {
            if (field.getDeclaringClass() != VCard.class || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(this, field.get(vCard));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("This cannot happen:" + field, illegalAccessException);
            }
        }
    }

    private void checkAuthenticated(XMPPConnection xMPPConnection, boolean bl) {
        if (xMPPConnection == null) {
            throw new IllegalArgumentException("No connection was provided");
        }
        if (!xMPPConnection.isAuthenticated()) {
            throw new IllegalArgumentException("Connection is not authenticated");
        }
        if (bl && xMPPConnection.isAnonymous()) {
            throw new IllegalArgumentException("Connection cannot be anonymous");
        }
    }

    private boolean hasContent() {
        return this.hasNameField() || this.hasOrganizationFields() || this.emailHome != null || this.emailWork != null || this.otherSimpleFields.size() > 0 || this.otherUnescapableFields.size() > 0 || this.homeAddr.size() > 0 || this.homePhones.size() > 0 || this.workAddr.size() > 0 || this.workPhones.size() > 0;
    }

    private boolean hasNameField() {
        return this.firstName != null || this.lastName != null || this.middleName != null;
    }

    private boolean hasOrganizationFields() {
        return this.organization != null || this.organizationUnit != null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VCard vCard = (VCard)object;
        if (this.emailHome != null ? !this.emailHome.equals(vCard.emailHome) : vCard.emailHome != null) {
            return false;
        }
        if (this.emailWork != null ? !this.emailWork.equals(vCard.emailWork) : vCard.emailWork != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(vCard.firstName) : vCard.firstName != null) {
            return false;
        }
        if (!((Object)this.homeAddr).equals(vCard.homeAddr)) {
            return false;
        }
        if (!((Object)this.homePhones).equals(vCard.homePhones)) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(vCard.lastName) : vCard.lastName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(vCard.middleName) : vCard.middleName != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(vCard.organization) : vCard.organization != null) {
            return false;
        }
        if (this.organizationUnit != null ? !this.organizationUnit.equals(vCard.organizationUnit) : vCard.organizationUnit != null) {
            return false;
        }
        if (!((Object)this.otherSimpleFields).equals(vCard.otherSimpleFields)) {
            return false;
        }
        if (!((Object)this.workAddr).equals(vCard.workAddr)) {
            return false;
        }
        return ((Object)this.workPhones).equals(vCard.workPhones);
    }

    @Override
    public int hashCode() {
        int n = ((Object)this.homePhones).hashCode();
        n = 29 * n + ((Object)this.workPhones).hashCode();
        n = 29 * n + ((Object)this.homeAddr).hashCode();
        n = 29 * n + ((Object)this.workAddr).hashCode();
        n = 29 * n + (this.firstName != null ? this.firstName.hashCode() : 0);
        n = 29 * n + (this.lastName != null ? this.lastName.hashCode() : 0);
        n = 29 * n + (this.middleName != null ? this.middleName.hashCode() : 0);
        n = 29 * n + (this.emailHome != null ? this.emailHome.hashCode() : 0);
        n = 29 * n + (this.emailWork != null ? this.emailWork.hashCode() : 0);
        n = 29 * n + (this.organization != null ? this.organization.hashCode() : 0);
        n = 29 * n + (this.organizationUnit != null ? this.organizationUnit.hashCode() : 0);
        n = 29 * n + ((Object)this.otherSimpleFields).hashCode();
        return n;
    }

    public String toString() {
        return this.getChildElementXML();
    }

    private static interface ContentBuilder {
        public void addTagContent();
    }

    private class VCardWriter {
        private final StringBuilder sb;

        VCardWriter(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        public void write() {
            this.appendTag("vCard", "xmlns", "vcard-temp", VCard.this.hasContent(), new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.buildActualContent();
                }
            });
        }

        private void buildActualContent() {
            if (VCard.this.hasNameField()) {
                this.appendN();
            }
            this.appendOrganization();
            this.appendGenericFields();
            this.appendEmail(VCard.this.emailWork, "WORK");
            this.appendEmail(VCard.this.emailHome, "HOME");
            this.appendPhones(VCard.this.workPhones, "WORK");
            this.appendPhones(VCard.this.homePhones, "HOME");
            this.appendAddress(VCard.this.workAddr, "WORK");
            this.appendAddress(VCard.this.homeAddr, "HOME");
        }

        private void appendEmail(final String string, final String string2) {
            if (string != null) {
                this.appendTag("EMAIL", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(string2);
                        VCardWriter.this.appendEmptyTag("INTERNET");
                        VCardWriter.this.appendEmptyTag("PREF");
                        VCardWriter.this.appendTag("USERID", StringUtils.escapeForXML(string));
                    }
                });
            }
        }

        private void appendPhones(Map<String, String> map, final String string) {
            for (final Map.Entry<String, String> entry : map.entrySet()) {
                this.appendTag("TEL", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(entry.getKey());
                        VCardWriter.this.appendEmptyTag(string);
                        VCardWriter.this.appendTag("NUMBER", StringUtils.escapeForXML((String)entry.getValue()));
                    }
                });
            }
        }

        private void appendAddress(final Map<String, String> map, final String string) {
            if (map.size() > 0) {
                this.appendTag("ADR", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(string);
                        for (Map.Entry entry : map.entrySet()) {
                            VCardWriter.this.appendTag((String)entry.getKey(), StringUtils.escapeForXML((String)entry.getValue()));
                        }
                    }
                });
            }
        }

        private void appendEmptyTag(Object object) {
            this.sb.append('<').append(object).append("/>");
        }

        private void appendGenericFields() {
            for (Map.Entry entry : VCard.this.otherSimpleFields.entrySet()) {
                this.appendTag(entry.getKey().toString(), StringUtils.escapeForXML((String)entry.getValue()));
            }
            for (Map.Entry entry : VCard.this.otherUnescapableFields.entrySet()) {
                this.appendTag(entry.getKey().toString(), (String)entry.getValue());
            }
        }

        private void appendOrganization() {
            if (VCard.this.hasOrganizationFields()) {
                this.appendTag("ORG", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendTag("ORGNAME", StringUtils.escapeForXML(VCard.this.organization));
                        VCardWriter.this.appendTag("ORGUNIT", StringUtils.escapeForXML(VCard.this.organizationUnit));
                    }
                });
            }
        }

        private void appendN() {
            this.appendTag("N", true, new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.appendTag("FAMILY", StringUtils.escapeForXML(VCard.this.lastName));
                    VCardWriter.this.appendTag("GIVEN", StringUtils.escapeForXML(VCard.this.firstName));
                    VCardWriter.this.appendTag("MIDDLE", StringUtils.escapeForXML(VCard.this.middleName));
                }
            });
        }

        private void appendTag(String string, String string2, String string3, boolean bl, ContentBuilder contentBuilder) {
            this.sb.append('<').append(string);
            if (string2 != null) {
                this.sb.append(' ').append(string2).append('=').append('\'').append(string3).append('\'');
            }
            if (bl) {
                this.sb.append('>');
                contentBuilder.addTagContent();
                this.sb.append("</").append(string).append(">\n");
            } else {
                this.sb.append("/>\n");
            }
        }

        private void appendTag(String string, boolean bl, ContentBuilder contentBuilder) {
            this.appendTag(string, null, null, bl, contentBuilder);
        }

        private void appendTag(String string, final String string2) {
            if (string2 == null) {
                return;
            }
            ContentBuilder contentBuilder = new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.sb.append(string2.trim());
                }
            };
            this.appendTag(string, true, contentBuilder);
        }
    }
}

