/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;

public class DelayInformation
implements PacketExtension {
    public static SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static SimpleDateFormat NEW_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private Date stamp;
    private String from;
    private String reason;

    public DelayInformation(Date date) {
        this.stamp = date;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public Date getStamp() {
        return this.stamp;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "jabber:x:delay";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\"");
        stringBuilder.append(" stamp=\"");
        SimpleDateFormat simpleDateFormat = UTC_FORMAT;
        synchronized (simpleDateFormat) {
            stringBuilder.append(UTC_FORMAT.format(this.stamp));
        }
        stringBuilder.append("\"");
        if (this.from != null && this.from.length() > 0) {
            stringBuilder.append(" from=\"").append(this.from).append("\"");
        }
        stringBuilder.append(">");
        if (this.reason != null && this.reason.length() > 0) {
            stringBuilder.append(this.reason);
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        NEW_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

