/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class FaultTolerantNegotiator
extends StreamNegotiator {
    private StreamNegotiator primaryNegotiator;
    private StreamNegotiator secondaryNegotiator;
    private XMPPConnection connection;
    private PacketFilter primaryFilter;
    private PacketFilter secondaryFilter;

    public FaultTolerantNegotiator(XMPPConnection xMPPConnection, StreamNegotiator streamNegotiator, StreamNegotiator streamNegotiator2) {
        this.primaryNegotiator = streamNegotiator;
        this.secondaryNegotiator = streamNegotiator2;
        this.connection = xMPPConnection;
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String string, String string2) {
        if (this.primaryFilter == null || this.secondaryFilter == null) {
            this.primaryFilter = this.primaryNegotiator.getInitiationPacketFilter(string, string2);
            this.secondaryFilter = this.secondaryNegotiator.getInitiationPacketFilter(string, string2);
        }
        return new OrFilter(this.primaryFilter, this.secondaryFilter);
    }

    @Override
    InputStream negotiateIncomingStream(Packet packet) throws XMPPException {
        throw new UnsupportedOperationException("Negotiation only handled by create incoming stream method.");
    }

    @Override
    final Packet initiateIncomingStream(XMPPConnection xMPPConnection, StreamInitiation streamInitiation) {
        throw new UnsupportedOperationException("Initiation handled by createIncomingStream method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream createIncomingStream(StreamInitiation streamInitiation) throws XMPPException {
        PacketCollector packetCollector = this.connection.createPacketCollector(this.getInitiationPacketFilter(streamInitiation.getFrom(), streamInitiation.getSessionID()));
        this.connection.sendPacket(super.createInitiationAccept(streamInitiation, this.getNamespaces()));
        ExecutorCompletionService<InputStream> executorCompletionService = new ExecutorCompletionService<InputStream>(Executors.newFixedThreadPool(2));
        ArrayList<Future<InputStream>> arrayList = new ArrayList<Future<InputStream>>();
        InputStream inputStream = null;
        XMPPException xMPPException = null;
        try {
            arrayList.add(executorCompletionService.submit(new NegotiatorService(packetCollector)));
            arrayList.add(executorCompletionService.submit(new NegotiatorService(packetCollector)));
            int n = 0;
            while (inputStream == null && n < arrayList.size()) {
                Future future;
                try {
                    ++n;
                    future = executorCompletionService.poll(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException executionException) {
                    continue;
                }
                if (future == null) continue;
                try {
                    inputStream = (InputStream)future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    xMPPException = new XMPPException(executionException.getCause());
                }
            }
        }
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
            packetCollector.cancel();
        }
        if (inputStream == null) {
            if (xMPPException != null) {
                throw xMPPException;
            }
            throw new XMPPException("File transfer negotiation failed.");
        }
        return inputStream;
    }

    private StreamNegotiator determineNegotiator(Packet packet) {
        return this.primaryFilter.accept(packet) ? this.primaryNegotiator : this.secondaryNegotiator;
    }

    @Override
    public OutputStream createOutgoingStream(String string, String string2, String string3) throws XMPPException {
        OutputStream outputStream;
        try {
            outputStream = this.primaryNegotiator.createOutgoingStream(string, string2, string3);
        }
        catch (XMPPException xMPPException) {
            outputStream = this.secondaryNegotiator.createOutgoingStream(string, string2, string3);
        }
        return outputStream;
    }

    @Override
    public String[] getNamespaces() {
        String[] stringArray = this.primaryNegotiator.getNamespaces();
        String[] stringArray2 = this.secondaryNegotiator.getNamespaces();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    @Override
    public void cleanup() {
    }

    private class NegotiatorService
    implements Callable<InputStream> {
        private PacketCollector collector;

        NegotiatorService(PacketCollector packetCollector) {
            this.collector = packetCollector;
        }

        @Override
        public InputStream call() throws Exception {
            Packet packet = this.collector.nextResult(SmackConfiguration.getPacketReplyTimeout() * 2);
            if (packet == null) {
                throw new XMPPException("No response from remote client");
            }
            StreamNegotiator streamNegotiator = FaultTolerantNegotiator.this.determineNegotiator(packet);
            return streamNegotiator.negotiateIncomingStream(packet);
        }
    }
}

