/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.OfflineMessageHeader;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.packet.OfflineMessageRequest;

public class OfflineMessageManager {
    private static final String namespace = "http://jabber.org/protocol/offline";
    private XMPPConnection connection;
    private PacketFilter packetFilter;

    public OfflineMessageManager(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.packetFilter = new AndFilter(new PacketExtensionFilter("offline", namespace), new PacketTypeFilter(Message.class));
    }

    public boolean supportsFlexibleRetrieval() throws XMPPException {
        DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null);
        return discoverInfo.containsFeature(namespace);
    }

    public int getMessageCount() throws XMPPException {
        DiscoverInfo discoverInfo = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null, namespace);
        Form form = Form.getFormFrom(discoverInfo);
        if (form != null) {
            String string = form.getField("number_of_messages").getValues().next();
            return Integer.parseInt(string);
        }
        return 0;
    }

    public Iterator<OfflineMessageHeader> getHeaders() throws XMPPException {
        ArrayList<OfflineMessageHeader> arrayList = new ArrayList<OfflineMessageHeader>();
        DiscoverItems discoverItems = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverItems(null, namespace);
        Iterator<DiscoverItems.Item> iterator = discoverItems.getItems();
        while (iterator.hasNext()) {
            DiscoverItems.Item item = iterator.next();
            arrayList.add(new OfflineMessageHeader(item));
        }
        return arrayList.iterator();
    }

    public Iterator<Message> getMessages(final List<String> list) throws XMPPException {
        Object object;
        ArrayList<Message> arrayList = new ArrayList<Message>();
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        for (String object22 : list) {
            object = new OfflineMessageRequest.Item(object22);
            ((OfflineMessageRequest.Item)object).setAction("view");
            offlineMessageRequest.addItem((OfflineMessageRequest.Item)object);
        }
        PacketIDFilter packetIDFilter = new PacketIDFilter(offlineMessageRequest.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        object = new AndFilter(this.packetFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                OfflineMessageInfo offlineMessageInfo = (OfflineMessageInfo)packet.getExtension("offline", OfflineMessageManager.namespace);
                return list.contains(offlineMessageInfo.getNode());
            }
        });
        PacketCollector packetCollector2 = this.connection.createPacketCollector((PacketFilter)object);
        this.connection.sendPacket(offlineMessageRequest);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        Message message = (Message)packetCollector2.nextResult(SmackConfiguration.getPacketReplyTimeout());
        while (message != null) {
            arrayList.add(message);
            message = (Message)packetCollector2.nextResult(SmackConfiguration.getPacketReplyTimeout());
        }
        packetCollector2.cancel();
        return arrayList.iterator();
    }

    public Iterator<Message> getMessages() throws XMPPException {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setFetch(true);
        PacketIDFilter packetIDFilter = new PacketIDFilter(offlineMessageRequest.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        PacketCollector packetCollector2 = this.connection.createPacketCollector(this.packetFilter);
        this.connection.sendPacket(offlineMessageRequest);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
        Message message = (Message)packetCollector2.nextResult(SmackConfiguration.getPacketReplyTimeout());
        while (message != null) {
            arrayList.add(message);
            message = (Message)packetCollector2.nextResult(SmackConfiguration.getPacketReplyTimeout());
        }
        packetCollector2.cancel();
        return arrayList.iterator();
    }

    public void deleteMessages(List<String> list) throws XMPPException {
        Object object;
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        for (String object22 : list) {
            object = new OfflineMessageRequest.Item(object22);
            ((OfflineMessageRequest.Item)object).setAction("remove");
            offlineMessageRequest.addItem((OfflineMessageRequest.Item)object);
        }
        PacketIDFilter packetIDFilter = new PacketIDFilter(offlineMessageRequest.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(offlineMessageRequest);
        object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (object == null) {
            throw new XMPPException("No response from server.");
        }
        if (((Packet)object).getError() != null) {
            throw new XMPPException(((Packet)object).getError());
        }
    }

    public void deleteMessages() throws XMPPException {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setPurge(true);
        PacketIDFilter packetIDFilter = new PacketIDFilter(offlineMessageRequest.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(offlineMessageRequest);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getError() != null) {
            throw new XMPPException(iQ.getError());
        }
    }
}

