/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.packet.LastActivity;

public class LastActivityManager {
    private long lastMessageSent;
    private XMPPConnection connection;

    private LastActivityManager(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        xMPPConnection.addPacketWriterListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                LastActivityManager.this.resetIdleTime();
            }
        }, null);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                LastActivity lastActivity = new LastActivity();
                lastActivity.setType(IQ.Type.RESULT);
                lastActivity.setTo(packet.getFrom());
                lastActivity.setFrom(packet.getTo());
                lastActivity.setPacketID(packet.getPacketID());
                lastActivity.setLastActivity(LastActivityManager.this.getIdleTime());
                LastActivityManager.this.connection.sendPacket(lastActivity);
            }
        }, new AndFilter(new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(LastActivity.class)));
    }

    private void resetIdleTime() {
        this.lastMessageSent = System.currentTimeMillis();
    }

    private long getIdleTime() {
        long l = System.currentTimeMillis();
        return (l - this.lastMessageSent) / 1000L;
    }

    public static LastActivity getLastActivity(XMPPConnection xMPPConnection, String string) throws XMPPException {
        LastActivity lastActivity = new LastActivity();
        lastActivity.setTo(string);
        PacketCollector packetCollector = xMPPConnection.createPacketCollector(new PacketIDFilter(lastActivity.getPacketID()));
        xMPPConnection.sendPacket(lastActivity);
        LastActivity lastActivity2 = (LastActivity)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (lastActivity2 == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (lastActivity2.getError() != null) {
            throw new XMPPException(lastActivity2.getError());
        }
        return lastActivity2;
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                new LastActivityManager(xMPPConnection);
            }
        });
    }
}

