/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class RosterPacket
extends IQ {
    private final List<Item> rosterItems = new ArrayList<Item>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.rosterItems));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:roster\">");
        List<Item> list = this.rosterItems;
        synchronized (list) {
            for (Item item : this.rosterItems) {
                stringBuilder.append(item.toXML());
            }
        }
        stringBuilder.append("</query>");
        return stringBuilder.toString();
    }

    public static enum ItemType {
        none,
        to,
        from,
        both,
        remove;

    }

    public static class ItemStatus {
        public static final ItemStatus SUBSCRIPTION_PENDING = new ItemStatus("subscribe");
        public static final ItemStatus UNSUBSCRIPTION_PENDING = new ItemStatus("unsubscribe");
        private String value;

        public static ItemStatus fromString(String string) {
            if (string == null) {
                return null;
            }
            if ("unsubscribe".equals(string = string.toLowerCase())) {
                return UNSUBSCRIPTION_PENDING;
            }
            if ("subscribe".equals(string)) {
                return SUBSCRIPTION_PENDING;
            }
            return null;
        }

        private ItemStatus(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Item {
        private String user;
        private String name;
        private ItemType itemType;
        private ItemStatus itemStatus;
        private final Set<String> groupNames;

        public Item(String string, String string2) {
            this.user = string.toLowerCase();
            this.name = string2;
            this.itemType = null;
            this.itemStatus = null;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        public String getUser() {
            return this.user;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = itemType;
        }

        public ItemStatus getItemStatus() {
            return this.itemStatus;
        }

        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public void addGroupName(String string) {
            this.groupNames.add(string);
        }

        public void removeGroupName(String string) {
            this.groupNames.remove(string);
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item jid=\"").append(this.user).append("\"");
            if (this.name != null) {
                stringBuilder.append(" name=\"").append(StringUtils.escapeForXML(this.name)).append("\"");
            }
            if (this.itemType != null) {
                stringBuilder.append(" subscription=\"").append((Object)this.itemType).append("\"");
            }
            if (this.itemStatus != null) {
                stringBuilder.append(" ask=\"").append(this.itemStatus).append("\"");
            }
            stringBuilder.append(">");
            for (String string : this.groupNames) {
                stringBuilder.append("<group>").append(StringUtils.escapeForXML(string)).append("</group>");
            }
            stringBuilder.append("</item>");
            return stringBuilder.toString();
        }
    }
}

