/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

public class PrivacyItem {
    private boolean allow;
    private int order;
    private PrivacyRule rule;
    private boolean filterIQ = false;
    private boolean filterMessage = false;
    private boolean filterPresence_in = false;
    private boolean filterPresence_out = false;

    public PrivacyItem(String string, boolean bl, int n) {
        this.setRule(PrivacyRule.fromString(string));
        this.setAllow(bl);
        this.setOrder(n);
    }

    public boolean isAllow() {
        return this.allow;
    }

    private void setAllow(boolean bl) {
        this.allow = bl;
    }

    public boolean isFilterIQ() {
        return this.filterIQ;
    }

    public void setFilterIQ(boolean bl) {
        this.filterIQ = bl;
    }

    public boolean isFilterMessage() {
        return this.filterMessage;
    }

    public void setFilterMessage(boolean bl) {
        this.filterMessage = bl;
    }

    public boolean isFilterPresence_in() {
        return this.filterPresence_in;
    }

    public void setFilterPresence_in(boolean bl) {
        this.filterPresence_in = bl;
    }

    public boolean isFilterPresence_out() {
        return this.filterPresence_out;
    }

    public void setFilterPresence_out(boolean bl) {
        this.filterPresence_out = bl;
    }

    public int getOrder() {
        return this.order;
    }

    private void setOrder(int n) {
        this.order = n;
    }

    public void setValue(String string) {
        if (this.getRule() != null || string != null) {
            this.getRule().setValue(string);
        }
    }

    public Type getType() {
        if (this.getRule() == null) {
            return null;
        }
        return this.getRule().getType();
    }

    public String getValue() {
        if (this.getRule() == null) {
            return null;
        }
        return this.getRule().getValue();
    }

    public boolean isFilterEverything() {
        return !this.isFilterIQ() && !this.isFilterMessage() && !this.isFilterPresence_in() && !this.isFilterPresence_out();
    }

    private PrivacyRule getRule() {
        return this.rule;
    }

    private void setRule(PrivacyRule privacyRule) {
        this.rule = privacyRule;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<item");
        if (this.isAllow()) {
            stringBuilder.append(" action=\"allow\"");
        } else {
            stringBuilder.append(" action=\"deny\"");
        }
        stringBuilder.append(" order=\"").append(this.getOrder()).append("\"");
        if (this.getType() != null) {
            stringBuilder.append(" type=\"").append((Object)this.getType()).append("\"");
        }
        if (this.getValue() != null) {
            stringBuilder.append(" value=\"").append(this.getValue()).append("\"");
        }
        if (this.isFilterEverything()) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append(">");
            if (this.isFilterIQ()) {
                stringBuilder.append("<iq/>");
            }
            if (this.isFilterMessage()) {
                stringBuilder.append("<message/>");
            }
            if (this.isFilterPresence_in()) {
                stringBuilder.append("<presence-in/>");
            }
            if (this.isFilterPresence_out()) {
                stringBuilder.append("<presence-out/>");
            }
            stringBuilder.append("</item>");
        }
        return stringBuilder.toString();
    }

    public static enum Type {
        group,
        jid,
        subscription;

    }

    public static class PrivacyRule {
        private Type type;
        private String value;
        public static final String SUBSCRIPTION_BOTH = "both";
        public static final String SUBSCRIPTION_TO = "to";
        public static final String SUBSCRIPTION_FROM = "from";
        public static final String SUBSCRIPTION_NONE = "none";

        protected static PrivacyRule fromString(String string) {
            if (string == null) {
                return null;
            }
            PrivacyRule privacyRule = new PrivacyRule();
            privacyRule.setType(Type.valueOf(string.toLowerCase()));
            return privacyRule;
        }

        public Type getType() {
            return this.type;
        }

        private void setType(Type type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        protected void setValue(String string) {
            if (this.isSuscription()) {
                this.setSuscriptionValue(string);
            } else {
                this.value = string;
            }
        }

        private void setSuscriptionValue(String string) {
            if (string == null) {
                // empty if block
            }
            String string2 = SUBSCRIPTION_BOTH.equalsIgnoreCase(string) ? SUBSCRIPTION_BOTH : (SUBSCRIPTION_TO.equalsIgnoreCase(string) ? SUBSCRIPTION_TO : (SUBSCRIPTION_FROM.equalsIgnoreCase(string) ? SUBSCRIPTION_FROM : (SUBSCRIPTION_NONE.equalsIgnoreCase(string) ? SUBSCRIPTION_NONE : null)));
            this.value = string2;
        }

        public boolean isSuscription() {
            return this.getType() == Type.subscription;
        }
    }
}

