/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Message
extends Packet {
    private Type type = Type.normal;
    private String subject = null;
    private String thread = null;
    private String language;
    private final Set<Body> bodies = new HashSet<Body>();

    public Message() {
    }

    public Message(String string) {
        this.setTo(string);
    }

    public Message(String string, Type type) {
        this.setTo(string);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getBody() {
        return this.getBody(null);
    }

    public String getBody(String string) {
        string = Message.parseXMLLang(string);
        for (Body body : this.bodies) {
            if ((body.langauge != null || string != null) && (body == null || !body.langauge.equals(string))) continue;
            return body.message;
        }
        return null;
    }

    public Collection<Body> getBodies() {
        return Collections.unmodifiableCollection(this.bodies);
    }

    public void setBody(String string) {
        if (string == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, string);
    }

    public Body addBody(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Body must be specified");
        }
        string = Message.parseXMLLang(string);
        Body body = new Body(string, string2);
        this.bodies.add(body);
        return body;
    }

    public boolean removeBody(String string) {
        string = Message.parseXMLLang(string);
        for (Body body : this.bodies) {
            if (!string.equals(body.langauge)) continue;
            return this.bodies.remove(body);
        }
        return false;
    }

    public boolean removeBody(Body body) {
        return this.bodies.remove(body);
    }

    public Collection<String> getBodyLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>(this.bodies.size());
        for (Body body : this.bodies) {
            if (Message.parseXMLLang(body.langauge).equals(Message.getDefaultLanguage())) continue;
            arrayList.add(body.langauge);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String string) {
        this.thread = string;
    }

    private String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<message");
        if (this.getXmlns() != null) {
            stringBuilder.append(" xmlns=\"").append(this.getXmlns()).append("\"");
        }
        if (this.language != null) {
            stringBuilder.append(" xml:lang=\"").append(this.getLanguage()).append("\"");
        }
        if (this.getPacketID() != null) {
            stringBuilder.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            stringBuilder.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            stringBuilder.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.normal) {
            stringBuilder.append(" type=\"").append((Object)this.type).append("\"");
        }
        stringBuilder.append(">");
        if (this.subject != null) {
            stringBuilder.append("<subject>").append(StringUtils.escapeForXML(this.subject)).append("</subject>");
        }
        if (this.getBody() != null) {
            stringBuilder.append("<body>").append(StringUtils.escapeForXML(this.getBody())).append("</body>");
        }
        Object object = this.getBodies().iterator();
        while (object.hasNext()) {
            Body body = object.next();
            if (DEFAULT_LANGUAGE.equals(body.getLanguage()) || body.getLanguage() == null) continue;
            stringBuilder.append("<body xml:lang=\"").append(body.getLanguage()).append("\">");
            stringBuilder.append(StringUtils.escapeForXML(body.getMessage()));
            stringBuilder.append("</body>");
        }
        if (this.thread != null) {
            stringBuilder.append("<thread>").append(this.thread).append("</thread>");
        }
        if (this.type == Type.error && (object = this.getError()) != null) {
            stringBuilder.append(((XMPPError)object).toXML());
        }
        stringBuilder.append(this.getExtensionsXML());
        stringBuilder.append("</message>");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        if (!super.equals(message)) {
            return false;
        }
        if (this.bodies.size() != message.bodies.size() || !this.bodies.containsAll(message.bodies)) {
            return false;
        }
        if (this.language != null ? !this.language.equals(message.language) : message.language != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(message.subject) : message.subject != null) {
            return false;
        }
        if (this.thread != null ? !this.thread.equals(message.thread) : message.thread != null) {
            return false;
        }
        return this.type == message.type;
    }

    @Override
    public int hashCode() {
        int n = this.type != null ? this.type.hashCode() : 0;
        n = 31 * n + (this.subject != null ? this.subject.hashCode() : 0);
        n = 31 * n + (this.thread != null ? this.thread.hashCode() : 0);
        n = 31 * n + (this.language != null ? this.language.hashCode() : 0);
        n = 31 * n + ((Object)this.bodies).hashCode();
        return n;
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String string) {
            try {
                return Type.valueOf(string);
            }
            catch (Exception exception) {
                return normal;
            }
        }
    }

    public static class Body {
        private String message;
        private String langauge;

        private Body(String string, String string2) {
            if (string2 == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.langauge = string;
            this.message = string2;
        }

        public String getLanguage() {
            if (Packet.DEFAULT_LANGUAGE.equals(this.langauge)) {
                return null;
            }
            return this.langauge;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Body body = (Body)object;
            if (this.langauge != null ? !this.langauge.equals(body.langauge) : body.langauge != null) {
                return false;
            }
            return this.message.equals(body.message);
        }

        public int hashCode() {
            int n = this.message.hashCode();
            n = 31 * n + (this.langauge != null ? this.langauge.hashCode() : 0);
            return n;
        }
    }
}

