/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public final class SmackConfiguration {
    private static final String SMACK_VERSION = "3.1.0";
    private static int packetReplyTimeout = 5000;
    private static int keepAliveInterval = 30000;
    private static Vector<String> defaultMechs = new Vector();

    private SmackConfiguration() {
    }

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getPacketReplyTimeout() {
        if (packetReplyTimeout <= 0) {
            packetReplyTimeout = 5000;
        }
        return packetReplyTimeout;
    }

    public static void setPacketReplyTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        packetReplyTimeout = n;
    }

    public static int getKeepAliveInterval() {
        return keepAliveInterval;
    }

    public static void setKeepAliveInterval(int n) {
        keepAliveInterval = n;
    }

    public static void addSaslMech(String string) {
        if (!defaultMechs.contains(string)) {
            defaultMechs.add(string);
        }
    }

    public static void addSaslMechs(Collection<String> collection) {
        for (String string : collection) {
            SmackConfiguration.addSaslMech(string);
        }
    }

    public static void removeSaslMech(String string) {
        if (defaultMechs.contains(string)) {
            defaultMechs.remove(string);
        }
    }

    public static void removeSaslMechs(Collection<String> collection) {
        for (String string : collection) {
            SmackConfiguration.removeSaslMech(string);
        }
    }

    public static List<String> getSaslMechs() {
        return defaultMechs;
    }

    private static void parseClassToLoad(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.nextText();
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error! A startup class specified in smack-config.xml could not be loaded: " + string);
        }
    }

    private static int parseIntProperty(XmlPullParser xmlPullParser, int n) throws Exception {
        try {
            return Integer.parseInt(xmlPullParser.nextText());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return n;
        }
    }

    private static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaderArray = new ClassLoader[]{SmackConfiguration.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            arrayList.add(classLoader);
        }
        return arrayList.toArray(new ClassLoader[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ClassLoader[] classLoaderArray;
            for (ClassLoader classLoader : classLoaderArray = SmackConfiguration.getClassLoaders()) {
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/smack-config.xml");
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = null;
                    try {
                        inputStream = uRL.openStream();
                        XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
                        xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                        xmlPullParser.setInput(inputStream, "UTF-8");
                        int n = xmlPullParser.getEventType();
                        do {
                            if (n != 2) continue;
                            if (xmlPullParser.getName().equals("className")) {
                                SmackConfiguration.parseClassToLoad(xmlPullParser);
                                continue;
                            }
                            if (xmlPullParser.getName().equals("packetReplyTimeout")) {
                                packetReplyTimeout = SmackConfiguration.parseIntProperty(xmlPullParser, packetReplyTimeout);
                                continue;
                            }
                            if (xmlPullParser.getName().equals("keepAliveInterval")) {
                                keepAliveInterval = SmackConfiguration.parseIntProperty(xmlPullParser, keepAliveInterval);
                                continue;
                            }
                            if (!xmlPullParser.getName().equals("mechName")) continue;
                            defaultMechs.add(xmlPullParser.nextText());
                        } while ((n = xmlPullParser.next()) != 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

