/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class RosterGroup {
    private String name;
    private XMPPConnection connection;
    private final List<RosterEntry> entries;

    RosterGroup(String string, XMPPConnection xMPPConnection) {
        this.name = string;
        this.connection = xMPPConnection;
        this.entries = new ArrayList<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            for (RosterEntry rosterEntry : this.entries) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.removeGroupName(this.name);
                item.addGroupName(string);
                rosterPacket.addRosterItem(item);
                this.connection.sendPacket(rosterPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RosterEntry> getEntries() {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<RosterEntry>(this.entries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(String string) {
        if (string == null) {
            return null;
        }
        string = StringUtils.parseBareAddress(string);
        String string2 = string.toLowerCase();
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            for (RosterEntry rosterEntry : this.entries) {
                if (!rosterEntry.getUser().equals(string2)) continue;
                return rosterEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RosterEntry rosterEntry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return this.entries.contains(rosterEntry);
        }
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry rosterEntry) throws XMPPException {
        PacketCollector packetCollector = null;
        Object object = this.entries;
        synchronized (object) {
            if (!this.entries.contains(rosterEntry)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.addGroupName(this.getName());
                rosterPacket.addRosterItem(item);
                packetCollector = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
                this.connection.sendPacket(rosterPacket);
            }
        }
        if (packetCollector != null) {
            object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            packetCollector.cancel();
            if (object == null) {
                throw new XMPPException("No response from the server.");
            }
            if (((IQ)object).getType() == IQ.Type.ERROR) {
                throw new XMPPException(((Packet)object).getError());
            }
            this.addEntryLocal(rosterEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry rosterEntry) throws XMPPException {
        PacketCollector packetCollector = null;
        Object object = this.entries;
        synchronized (object) {
            if (this.entries.contains(rosterEntry)) {
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                RosterPacket.Item item = RosterEntry.toRosterItem(rosterEntry);
                item.removeGroupName(this.getName());
                rosterPacket.addRosterItem(item);
                packetCollector = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
                this.connection.sendPacket(rosterPacket);
            }
        }
        if (packetCollector != null) {
            object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            packetCollector.cancel();
            if (object == null) {
                throw new XMPPException("No response from the server.");
            }
            if (((IQ)object).getType() == IQ.Type.ERROR) {
                throw new XMPPException(((Packet)object).getError());
            }
            this.removeEntryLocal(rosterEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryLocal(RosterEntry rosterEntry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            this.entries.remove(rosterEntry);
            this.entries.add(rosterEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryLocal(RosterEntry rosterEntry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            if (this.entries.contains(rosterEntry)) {
                this.entries.remove(rosterEntry);
            }
        }
    }
}

