/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
implements ConnectionListener {
    private XMPPConnection connection;
    boolean done = false;

    private ReconnectionManager(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.getConfiguration().isReconnectionAllowed() && this.connection.packetReader != null;
    }

    protected void reconnect() {
        if (this.isReconnectionAllowed()) {
            Thread thread = new Thread(){
                private int attempts = 0;

                private int timeDelay() {
                    if (this.attempts > 13) {
                        return 300;
                    }
                    if (this.attempts > 7) {
                        return 60;
                    }
                    return 10;
                }

                @Override
                public void run() {
                    while (ReconnectionManager.this.isReconnectionAllowed()) {
                        int n = this.timeDelay();
                        while (ReconnectionManager.this.isReconnectionAllowed() && n > 0) {
                            try {
                                Thread.sleep(1000L);
                                ReconnectionManager.this.notifyAttemptToReconnectIn(--n);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                ReconnectionManager.this.notifyReconnectionFailed(interruptedException);
                            }
                        }
                        try {
                            if (!ReconnectionManager.this.isReconnectionAllowed()) continue;
                            ReconnectionManager.this.connection.connect();
                        }
                        catch (XMPPException xMPPException) {
                            ReconnectionManager.this.notifyReconnectionFailed(xMPPException);
                        }
                    }
                }
            };
            thread.setName("Smack Reconnection Manager");
            thread.setDaemon(true);
            thread.start();
        }
    }

    protected void notifyReconnectionFailed(Exception exception) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener connectionListener : this.connection.packetReader.connectionListeners) {
                connectionListener.reconnectionFailed(exception);
            }
        }
    }

    protected void notifyAttemptToReconnectIn(int n) {
        if (this.isReconnectionAllowed()) {
            for (ConnectionListener connectionListener : this.connection.packetReader.connectionListeners) {
                connectionListener.reconnectingIn(n);
            }
        }
    }

    @Override
    public void connectionClosed() {
        this.done = true;
    }

    @Override
    public void connectionClosedOnError(Exception exception) {
        String string;
        XMPPException xMPPException;
        StreamError streamError;
        this.done = false;
        if (exception instanceof XMPPException && (streamError = (xMPPException = (XMPPException)exception).getStreamError()) != null && "conflict".equals(string = streamError.getCode())) {
            return;
        }
        if (this.isReconnectionAllowed()) {
            this.reconnect();
        }
    }

    @Override
    public void reconnectingIn(int n) {
    }

    @Override
    public void reconnectionFailed(Exception exception) {
    }

    @Override
    public void reconnectionSuccessful() {
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                xMPPConnection.addConnectionListener(new ReconnectionManager(xMPPConnection));
            }
        });
    }
}

