/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Thread keepAliveThread;
    private Writer writer;
    private XMPPConnection connection;
    private final BlockingQueue<Packet> queue;
    private boolean done;
    private final Map<PacketListener, ListenerWrapper> listeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    private long lastActive = System.currentTimeMillis();
    private final Map<PacketInterceptor, InterceptorWrapper> interceptors = new ConcurrentHashMap<PacketInterceptor, InterceptorWrapper>();

    protected PacketWriter(XMPPConnection xMPPConnection) {
        this.queue = new ArrayBlockingQueue<Packet>(500, true);
        this.connection = xMPPConnection;
        this.init();
    }

    protected void init() {
        this.writer = this.connection.writer;
        this.done = false;
        this.writerThread = new Thread(){

            @Override
            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.connectionCounterValue + ")");
        this.writerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.processInterceptors(packet);
            try {
                this.queue.put(packet);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            BlockingQueue<Packet> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            this.processListeners(packet);
        }
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        this.listeners.put(packetListener, new ListenerWrapper(packetListener, packetFilter));
    }

    public void removePacketListener(PacketListener packetListener) {
        this.listeners.remove(packetListener);
    }

    public int getPacketListenerCount() {
        return this.listeners.size();
    }

    public void addPacketInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        this.interceptors.put(packetInterceptor, new InterceptorWrapper(packetInterceptor, packetFilter));
    }

    public void removePacketInterceptor(PacketInterceptor packetInterceptor) {
        this.interceptors.remove(packetInterceptor);
    }

    public void startup() {
        this.writerThread.start();
    }

    void startKeepAliveProcess() {
        int n = SmackConfiguration.getKeepAliveInterval();
        if (n > 0) {
            KeepAliveTask keepAliveTask = new KeepAliveTask(n);
            this.keepAliveThread = new Thread(keepAliveTask);
            keepAliveTask.setThread(this.keepAliveThread);
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.setName("Smack Keep Alive (" + this.connection.connectionCounterValue + ")");
            this.keepAliveThread.start();
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.done = true;
        BlockingQueue<Packet> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
        }
    }

    void cleanup() {
        this.interceptors.clear();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet nextPacket() {
        Packet packet = null;
        while (!this.done && (packet = (Packet)this.queue.poll()) == null) {
            try {
                BlockingQueue<Packet> blockingQueue = this.queue;
                synchronized (blockingQueue) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackets(Thread thread) {
        block24: {
            try {
                Object object;
                Object object2;
                this.openStream();
                while (!this.done && this.writerThread == thread) {
                    object2 = this.nextPacket();
                    if (object2 == null) continue;
                    object = this.writer;
                    synchronized (object) {
                        this.writer.write(((Packet)object2).toXML());
                        this.writer.flush();
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                try {
                    object2 = this.writer;
                    synchronized (object2) {
                        while (!this.queue.isEmpty()) {
                            object = (Packet)this.queue.remove();
                            this.writer.write(((Packet)object).toXML());
                        }
                        this.writer.flush();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.queue.clear();
                try {
                    this.writer.write("</stream:stream>");
                    this.writer.flush();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException iOException) {
                if (this.done) break block24;
                this.done = true;
                this.connection.packetReader.notifyConnectionError(iOException);
            }
        }
    }

    private void processListeners(Packet packet) {
        for (ListenerWrapper listenerWrapper : this.listeners.values()) {
            listenerWrapper.notifyListener(packet);
        }
    }

    private void processInterceptors(Packet packet) {
        if (packet != null) {
            for (InterceptorWrapper interceptorWrapper : this.interceptors.values()) {
                interceptorWrapper.notifyListener(packet);
            }
        }
    }

    void openStream() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<stream:stream");
        stringBuilder.append(" to=\"").append(this.connection.serviceName).append("\"");
        stringBuilder.append(" xmlns=\"jabber:client\"");
        stringBuilder.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stringBuilder.append(" version=\"1.0\">");
        this.writer.write(stringBuilder.toString());
        this.writer.flush();
    }

    private class KeepAliveTask
    implements Runnable {
        private int delay;
        private Thread thread;

        public KeepAliveTask(int n) {
            this.delay = n;
        }

        protected void setThread(Thread thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!PacketWriter.this.done && PacketWriter.this.keepAliveThread == this.thread) {
                Writer writer = PacketWriter.this.writer;
                synchronized (writer) {
                    if (System.currentTimeMillis() - PacketWriter.this.lastActive >= (long)this.delay) {
                        try {
                            PacketWriter.this.writer.write(" ");
                            PacketWriter.this.writer.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class InterceptorWrapper {
        private PacketInterceptor packetInterceptor;
        private PacketFilter packetFilter;

        public InterceptorWrapper(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof InterceptorWrapper) {
                return ((InterceptorWrapper)object).packetInterceptor.equals(this.packetInterceptor);
            }
            if (object instanceof PacketInterceptor) {
                return object.equals(this.packetInterceptor);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetInterceptor.interceptPacket(packet);
            }
        }
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }
}

