/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class PacketReader {
    private Thread readerThread;
    private ExecutorService listenerExecutor;
    private XMPPConnection connection;
    private XmlPullParser parser;
    private boolean done;
    private Collection<PacketCollector> collectors = new ConcurrentLinkedQueue<PacketCollector>();
    protected final Map<PacketListener, ListenerWrapper> listeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
    protected final Collection<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private String connectionID = null;
    private Semaphore connectionSemaphore;

    protected PacketReader(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    protected void init() {
        this.done = false;
        this.connectionID = null;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.connectionCounterValue + ")");
        this.readerThread.setDaemon(true);
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Smack Listener Processor (" + ((PacketReader)PacketReader.this).connection.connectionCounterValue + ")");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.resetParser();
    }

    public PacketCollector createPacketCollector(PacketFilter packetFilter) {
        PacketCollector packetCollector = new PacketCollector(this, packetFilter);
        this.collectors.add(packetCollector);
        return packetCollector;
    }

    protected void cancelPacketCollector(PacketCollector packetCollector) {
        this.collectors.remove(packetCollector);
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        ListenerWrapper listenerWrapper = new ListenerWrapper(packetListener, packetFilter);
        this.listeners.put(packetListener, listenerWrapper);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.listeners.remove(packetListener);
    }

    public void startup() throws XMPPException {
        this.connectionSemaphore = new Semaphore(1);
        this.readerThread.start();
        try {
            this.connectionSemaphore.acquire();
            int n = SmackConfiguration.getPacketReplyTimeout();
            this.connectionSemaphore.tryAcquire(3 * n, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    public void shutdown() {
        if (!this.done) {
            for (ConnectionListener connectionListener : this.connectionListeners) {
                try {
                    connectionListener.connectionClosed();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.done = true;
        this.listenerExecutor.shutdown();
    }

    void cleanup() {
        this.connectionListeners.clear();
        this.listeners.clear();
        this.collectors.clear();
    }

    void notifyConnectionError(Exception exception) {
        this.done = true;
        this.connection.shutdown(new Presence(Presence.Type.unavailable));
        exception.printStackTrace();
        for (ConnectionListener connectionListener : this.connectionListeners) {
            try {
                connectionListener.connectionClosedOnError(exception);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected void notifyReconnection() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            try {
                connectionListener.reconnectionSuccessful();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void resetParser() {
        try {
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    private void parsePackets(Thread thread) {
        block33: {
            try {
                int n = this.parser.getEventType();
                do {
                    if (n == 2) {
                        if (this.parser.getName().equals("message")) {
                            this.processPacket(PacketParserUtils.parseMessage(this.parser));
                        } else if (this.parser.getName().equals("iq")) {
                            this.processPacket(this.parseIQ(this.parser));
                        } else if (this.parser.getName().equals("presence")) {
                            this.processPacket(PacketParserUtils.parsePresence(this.parser));
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (this.parser.getAttributeName(i).equals("id")) {
                                        this.connectionID = this.parser.getAttributeValue(i);
                                        if ("1.0".equals(this.parser.getAttributeValue("", "version"))) continue;
                                        this.releaseConnectionIDLock();
                                        continue;
                                    }
                                    if (!this.parser.getAttributeName(i).equals("from")) continue;
                                    this.connection.serviceName = this.parser.getAttributeValue(i);
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException(this.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String string = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(string)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(string)) {
                                    this.connection.streamCompressionDenied();
                                } else {
                                    this.connection.getSASLAuthentication().authenticationFailed();
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                this.connection.getSASLAuthentication().challengeReceived(this.parser.nextText());
                            } else if (!this.parser.getName().equals("success") && this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (n == 3) {
                        if (this.parser.getName().equals("stream")) {
                            this.connection.disconnect();
                        } else if (this.parser.getName().equals("success")) {
                            this.connection.packetWriter.openStream();
                            this.resetParser();
                            this.connection.getSASLAuthentication().authenticated();
                        }
                    }
                    n = this.parser.next();
                } while (!this.done && n != 1 && thread == this.readerThread);
            }
            catch (Exception exception) {
                if (this.done) break block33;
                this.notifyConnectionError(exception);
            }
        }
    }

    private void releaseConnectionIDLock() {
        this.connectionSemaphore.release();
    }

    private void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector packetCollector : this.collectors) {
            packetCollector.processPacket(packet);
        }
        this.listenerExecutor.submit(new ListenerNotification(packet));
    }

    private StreamError parseStreamError(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        StreamError streamError = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                streamError = new StreamError(xmlPullParser.getName());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("error")) continue;
            bl = true;
        }
        return streamError;
    }

    private void parseFeatures(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl3) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("starttls")) {
                    bl = true;
                    continue;
                }
                if (xmlPullParser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(this.parseMechanisms(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (xmlPullParser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (xmlPullParser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(this.parseCompressionMethods(xmlPullParser));
                    continue;
                }
                if (!xmlPullParser.getName().equals("register")) continue;
                this.connection.getAccountManager().setSupportsAccountCreation(true);
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("starttls")) {
                this.connection.startTLSReceived(bl2);
                continue;
            }
            if (xmlPullParser.getName().equals("required") && bl) {
                bl2 = true;
                continue;
            }
            if (!xmlPullParser.getName().equals("features")) continue;
            bl3 = true;
        }
        if (!this.connection.isSecureConnection() && !bl && this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new XMPPException("Server does not support security (TLS), but security required by connection configuration.", new XMPPError(XMPPError.Condition.forbidden));
        }
        if (!bl || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.releaseConnectionIDLock();
        }
    }

    private Collection<String> parseMechanisms(XmlPullParser xmlPullParser) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string = xmlPullParser.getName();
                if (!string.equals("mechanism")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("mechanisms")) continue;
            bl = true;
        }
        return arrayList;
    }

    private Collection<String> parseCompressionMethods(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string = xmlPullParser.getName();
                if (!string.equals("method")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("compression")) continue;
            bl = true;
        }
        return arrayList;
    }

    private IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        Packet packet = null;
        String string = xmlPullParser.getAttributeValue("", "id");
        String string2 = xmlPullParser.getAttributeValue("", "to");
        String string3 = xmlPullParser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(xmlPullParser.getAttributeValue("", "type"));
        XMPPError xMPPError = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("error")) {
                    xMPPError = PacketParserUtils.parseError(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:auth")) {
                    packet = this.parseAuthentication(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:roster")) {
                    packet = this.parseRoster(xmlPullParser);
                    continue;
                }
                if (string4.equals("query") && string5.equals("jabber:iq:register")) {
                    packet = this.parseRegistration(xmlPullParser);
                    continue;
                }
                if (string4.equals("bind") && string5.equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                    packet = this.parseResourceBinding(xmlPullParser);
                    continue;
                }
                Object object = ProviderManager.getInstance().getIQProvider(string4, string5);
                if (object == null) continue;
                if (object instanceof IQProvider) {
                    packet = ((IQProvider)object).parseIQ(xmlPullParser);
                    continue;
                }
                if (!(object instanceof Class)) continue;
                packet = (IQ)PacketParserUtils.parseWithIntrospection(string4, (Class)object, xmlPullParser);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("iq")) continue;
            bl = true;
        }
        if (packet == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                packet = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return null;
                    }
                };
                packet.setPacketID(string);
                packet.setTo(string3);
                packet.setFrom(string2);
                ((IQ)packet).setType(IQ.Type.ERROR);
                packet.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                this.connection.sendPacket(packet);
                return null;
            }
            packet = new IQ(){

                @Override
                public String getChildElementXML() {
                    return null;
                }
            };
        }
        packet.setPacketID(string);
        packet.setTo(string2);
        packet.setFrom(string3);
        ((IQ)packet).setType(type);
        packet.setError(xMPPError);
        return packet;
    }

    private Authentication parseAuthentication(XmlPullParser xmlPullParser) throws Exception {
        Authentication authentication = new Authentication();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("username")) {
                    authentication.setUsername(xmlPullParser.nextText());
                    continue;
                }
                if (xmlPullParser.getName().equals("password")) {
                    authentication.setPassword(xmlPullParser.nextText());
                    continue;
                }
                if (xmlPullParser.getName().equals("digest")) {
                    authentication.setDigest(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("resource")) continue;
                authentication.setResource(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return authentication;
    }

    private RosterPacket parseRoster(XmlPullParser xmlPullParser) throws Exception {
        RosterPacket rosterPacket = new RosterPacket();
        boolean bl = false;
        RosterPacket.Item item = null;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("item")) {
                    String string = xmlPullParser.getAttributeValue("", "jid");
                    String string2 = xmlPullParser.getAttributeValue("", "name");
                    item = new RosterPacket.Item(string, string2);
                    String string3 = xmlPullParser.getAttributeValue("", "ask");
                    RosterPacket.ItemStatus itemStatus = RosterPacket.ItemStatus.fromString(string3);
                    item.setItemStatus(itemStatus);
                    String string4 = xmlPullParser.getAttributeValue("", "subscription");
                    RosterPacket.ItemType itemType = RosterPacket.ItemType.valueOf(string4);
                    item.setItemType(itemType);
                }
                if (!xmlPullParser.getName().equals("group") || item == null) continue;
                item.addGroupName(xmlPullParser.nextText());
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("item")) {
                rosterPacket.addRosterItem(item);
            }
            if (!xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return rosterPacket;
    }

    private Registration parseRegistration(XmlPullParser xmlPullParser) throws Exception {
        Registration registration = new Registration();
        HashMap<String, String> hashMap = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getNamespace().equals("jabber:iq:register")) {
                    String string = xmlPullParser.getName();
                    String string2 = "";
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    if (xmlPullParser.next() == 4) {
                        string2 = xmlPullParser.getText();
                    }
                    if (!string.equals("instructions")) {
                        hashMap.put(string, string2);
                        continue;
                    }
                    registration.setInstructions(string2);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        registration.setAttributes(hashMap);
        return registration;
    }

    private Bind parseResourceBinding(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("resource")) {
                    bind.setResource(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("jid")) continue;
                bind.setJid(xmlPullParser.nextText());
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("bind")) continue;
            bl = true;
        }
        return bind;
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (ListenerWrapper listenerWrapper : PacketReader.this.listeners.values()) {
                listenerWrapper.notifyListener(this.packet);
            }
        }
    }
}

