/*
 * Decompiled with CFR 0.152.
 */
package com.nullwire.trace;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.nullwire.trace.DefaultExceptionHandler;
import com.nullwire.trace.G;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class ExceptionHandler {
    public static String TAG = "com.nullwire.trace.ExceptionsHandler";
    private static String[] stackTraceFileList = null;

    public static boolean register(Context context) {
        Log.i((String)TAG, (String)"Registering default exceptions handler");
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            G.APP_VERSION = packageInfo.versionName;
            G.APP_PACKAGE = packageInfo.packageName;
            G.FILES_PATH = context.getFilesDir().getAbsolutePath();
            G.PHONE_MODEL = Build.MODEL;
            G.ANDROID_VERSION = Build.VERSION.RELEASE;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        Log.i((String)TAG, (String)("TRACE_VERSION: " + G.TraceVersion));
        Log.d((String)TAG, (String)("APP_VERSION: " + G.APP_VERSION));
        Log.d((String)TAG, (String)("APP_PACKAGE: " + G.APP_PACKAGE));
        Log.d((String)TAG, (String)("FILES_PATH: " + G.FILES_PATH));
        Log.d((String)TAG, (String)("URL: " + G.URL));
        boolean bl = false;
        if (ExceptionHandler.searchForStackTraces().length > 0) {
            bl = true;
        }
        new Thread(){

            @Override
            public void run() {
                ExceptionHandler.submitStackTraces();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                if (uncaughtExceptionHandler != null) {
                    Log.d((String)TAG, (String)("current handler class=" + uncaughtExceptionHandler.getClass().getName()));
                }
                if (!(uncaughtExceptionHandler instanceof DefaultExceptionHandler)) {
                    Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler(uncaughtExceptionHandler));
                }
            }
        }.start();
        return bl;
    }

    public static void register(Context context, String string) {
        Log.i((String)TAG, (String)("Registering default exceptions handler: " + string));
        G.URL = string;
        ExceptionHandler.register(context);
    }

    private static String[] searchForStackTraces() {
        if (stackTraceFileList != null) {
            return stackTraceFileList;
        }
        File file = new File(G.FILES_PATH + "/");
        file.mkdir();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".stacktrace");
            }
        };
        stackTraceFileList = file.list(filenameFilter);
        return stackTraceFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void submitStackTraces() {
        try {
            Log.d((String)TAG, (String)("Looking for exceptions in: " + G.FILES_PATH));
            String[] stringArray = ExceptionHandler.searchForStackTraces();
            if (stringArray != null && stringArray.length > 0) {
                Log.d((String)TAG, (String)("Found " + stringArray.length + " stacktrace(s)"));
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = G.FILES_PATH + "/" + stringArray[i];
                    String string2 = stringArray[i].split("-")[0];
                    Log.d((String)TAG, (String)("Stacktrace in file '" + (String)string + "' belongs to version " + string2));
                    StringBuilder stringBuilder = new StringBuilder();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if (string4 == null) {
                            string4 = string3;
                            continue;
                        }
                        if (string5 == null) {
                            string5 = string3;
                            continue;
                        }
                        stringBuilder.append(string3);
                        stringBuilder.append(System.getProperty("line.separator"));
                    }
                    bufferedReader.close();
                    String string6 = stringBuilder.toString();
                    Log.d((String)TAG, (String)("Transmitting stack trace: " + string6));
                    DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                    HttpPost httpPost = new HttpPost(G.URL);
                    ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                    arrayList.add(new BasicNameValuePair("package_name", G.APP_PACKAGE));
                    arrayList.add(new BasicNameValuePair("package_version", string2));
                    arrayList.add(new BasicNameValuePair("phone_model", string5));
                    arrayList.add(new BasicNameValuePair("android_version", string4));
                    arrayList.add(new BasicNameValuePair("stacktrace", string6));
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, "UTF-8"));
                    defaultHttpClient.execute((HttpUriRequest)httpPost);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                String[] stringArray = ExceptionHandler.searchForStackTraces();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(G.FILES_PATH + "/" + stringArray[i]);
                    file.delete();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

