package org.woheller69.eggtimer;

import static java.lang.Boolean.TRUE;

import android.Manifest;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.WindowInsetsController;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.preference.Preference;
import androidx.preference.PreferenceCategory;
import androidx.preference.PreferenceFragmentCompat;
import androidx.preference.PreferenceManager;
import androidx.preference.PreferenceScreen;
import com.google.android.material.color.DynamicColors;
public class SettingsActivity extends AppCompatActivity implements SharedPreferences.OnSharedPreferenceChangeListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.settings_activity);

        int nightModeFlags = getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;

        boolean isDarkMode = (nightModeFlags == Configuration.UI_MODE_NIGHT_YES);

        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
            WindowInsetsController insetsController = getWindow().getInsetsController();
            if (insetsController != null) {
                if (isDarkMode) {
                    // Dark mode: remove light status bar appearance (use light icons)
                    insetsController.setSystemBarsAppearance(
                            0,
                            WindowInsetsController.APPEARANCE_LIGHT_STATUS_BARS
                    );
                } else {
                    // Light mode: enable light status bar appearance (dark icons)
                    insetsController.setSystemBarsAppearance(
                            WindowInsetsController.APPEARANCE_LIGHT_STATUS_BARS,
                            WindowInsetsController.APPEARANCE_LIGHT_STATUS_BARS
                    );
                }
            }
        }

        if (savedInstanceState == null) {
            getSupportFragmentManager()
                    .beginTransaction()
                    .replace(R.id.settings, new SettingsFragment())
                    .commit();
        }
        ActionBar actionBar = getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        PreferenceManager.getDefaultSharedPreferences(this.getApplicationContext()).registerOnSharedPreferenceChangeListener(this);
    }

    public static class SettingsFragment extends PreferenceFragmentCompat {
        @Override
        public void onCreatePreferences(Bundle savedInstanceState, String rootKey) {
            setPreferencesFromResource(R.xml.root_preferences, rootKey);
            Preference reset = getPreferenceManager().findPreference("reset");
            PreferenceScreen preferenceScreen = getPreferenceScreen();
            if (Barometer.hasSensor(requireContext())){
                PreferenceCategory catGPS = (PreferenceCategory) findPreference("catGPS");
                preferenceScreen.removePreference(catGPS);
            }
            if (!DynamicColors.isDynamicColorAvailable()) {
                PreferenceCategory catColors = (PreferenceCategory) findPreference("catColors");
                preferenceScreen.removePreference(catColors);
            }

            if (reset != null) reset.setOnPreferenceClickListener(preference -> {
                SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(requireContext());

                sharedPreferences.edit().remove("soft").apply();
                sharedPreferences.edit().remove("medium").apply();
                sharedPreferences.edit().remove("hard").apply();
                sharedPreferences.edit().remove("xs_name").apply();
                sharedPreferences.edit().remove("xs_weight").apply();
                sharedPreferences.edit().remove("s_name").apply();
                sharedPreferences.edit().remove("s_weight").apply();
                sharedPreferences.edit().remove("m_name").apply();
                sharedPreferences.edit().remove("m_weight").apply();
                sharedPreferences.edit().remove("l_name").apply();
                sharedPreferences.edit().remove("l_weight").apply();
                sharedPreferences.edit().remove("xl_name").apply();
                sharedPreferences.edit().remove("xl_weight").apply();

                onCreatePreferences(savedInstanceState,rootKey);
                return false;
            });
        }
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String s) {
        if (s.equals("useGPS")) {
            if (sharedPreferences.getBoolean(s, true) == TRUE) {
                if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(this,
                            new String[]{Manifest.permission.ACCESS_COARSE_LOCATION, Manifest.permission.ACCESS_FINE_LOCATION,}, 1);
                }
            }
        } else if (s.equals("useDynamicColors")) {
            new AlertDialog.Builder(this)
                    .setTitle(getString(R.string.restart))
                    .setPositiveButton(android.R.string.yes, (dialog, which) -> {
                        AlarmReceiver.cancelAlarm(this);
                        Notification.cancelNotification(this);
                        Runtime.getRuntime().exit(0);
                    })
                    .show();
        }
    }

}