/*
 * Copyright (c) 2015, Nils Braden
 *
 * This file is part of ttrss-reader-fork. This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details. You should have received a
 * copy of the GNU General Public License along with this program; If
 * not, see http://www.gnu.org/licenses/.
 */

package org.ttrssreader.gui;


import android.os.Bundle;
import org.ttrssreader.R;

import androidx.appcompat.app.AppCompatActivity;

/**
 * This class is empty since we don't want to use the play services library here!
 */
public abstract class MenuFlavorActivity extends AppCompatActivity {

	@Override
	protected void onCreate(Bundle instance) {
		// Call before the DecorView is accessed in setContentView, see https://medium.com/androiddevelopers/insets-handling-tips-for-android-15s-edge-to-edge-enforcement-872774e8839b
		getTheme().applyStyle(R.style.OptOutEdgeToEdgeEnforcement, /* force */ false);

		super.onCreate(instance);
	}
}
