/*
 * ttrss-reader-fork for Android
 * 
 * Copyright (C) 2010 N. Braden.
 * Copyright (C) 2009-2010 J. Devauchelle.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 3 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

package org.ttrssreader.net;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONResult {
    
    private JSONArray names;
    private JSONArray values;
    
    // public TTRSSJsonResult(InputStream is) throws JSONException {
    // this(Utils.convertStreamToString(is));
    // }
    
    public JSONResult(String input) throws JSONException {
        
        JSONObject object = new JSONObject(input);
        
        names = object.names();
        values = object.toJSONArray(names);
        
    }
    
    public JSONArray getNames() {
        return names;
    }
    
    public JSONArray getValues() {
        return values;
    }
    
}
