/*
 * Copyright 2013 serso aka se.solovyev
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Contact details
 *
 * Email: se.solovyev@gmail.com
 * Site:  http://se.solovyev.org
 */

package org.solovyev.android.calculator.wizard;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import org.solovyev.android.calculator.App;
import org.solovyev.android.calculator.R;

import javax.annotation.Nonnull;

public final class WelcomeWizardStep extends WizardFragment {

    @Override
    protected int getViewResId() {
        return R.layout.cpp_wizard_step_welcome;
    }

    @Nonnull
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        final View view = super.onCreateView(inflater, container, savedInstanceState);
        if (App.getTheme().light) {
            final TextView message = (TextView) view.findViewById(R.id.wizard_welcome_message);
            message.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.logo_wizard_light, 0, 0);
        }
        prevButton.setTextColor(getResources().getColor(R.color.cpp_wizard_disabled_text));
        return view;
    }
}
