package org.softeg.slartus.forpdaplus.listfragments;

import android.os.Bundle;

import androidx.annotation.LayoutRes;
import androidx.fragment.app.Fragment;

import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

import org.softeg.slartus.forpdaplus.R;
import org.softeg.slartus.forpdaplus.fragments.GeneralFragment;
import org.softeg.slartus.forpdaplus.listtemplates.BrickInfo;

public abstract class BaseBrickFragment extends GeneralFragment {

    public static final String NAME_KEY = "NAME_KEY";
    public static final String TITLE_KEY = "TITLE_KEY";
    public static final String NEED_LOGIN_KEY = "NEED_LOGIN_KEY";

    private String m_Title = "";
    private String m_Name = "base";
    private Boolean m_NeedLogin = false;

    public BaseBrickFragment() {
        super();
    }

    public BaseBrickFragment(@LayoutRes int contentLayoutId) {
        super(contentLayoutId);
    }

    @Override
    public boolean closeTab() {
        return false;
    }

    /**
     * Заголовок списка
     */
    @Override
    public String getListTitle() {
        return m_Title;
    }

    /**
     * Уникальный идентификатор списка
     */
    @Override
    public String getListName() {
        return m_Name;
    }


    public Boolean needLogin() {
        return m_NeedLogin;
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public Fragment setBrickInfo(BrickInfo listTemplate) {
        m_Title = listTemplate.getTitle();
        m_Name = listTemplate.getName();
        m_NeedLogin = listTemplate.getNeedLogin();
        return this;
    }

    protected Bundle args = new Bundle();

    @Override
    public void onCreate(android.os.Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (getArguments() != null) {
            args = getArguments();
        }
        if (savedInstanceState != null) {
            args = savedInstanceState;
        }

        if (savedInstanceState != null) {
            m_Name = savedInstanceState.getString(NAME_KEY, m_Name);
            m_Title = savedInstanceState.getString(TITLE_KEY, m_Title);
            m_NeedLogin = savedInstanceState.getBoolean(NEED_LOGIN_KEY, m_NeedLogin);
        }
    }

    @Override
    public void onSaveInstanceState(android.os.Bundle outState) {
        outState.putString(NAME_KEY, m_Name);
        outState.putString(TITLE_KEY, m_Title);
        outState.putBoolean(NEED_LOGIN_KEY, m_NeedLogin);

        super.onSaveInstanceState(outState);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.refresh_item) {
            loadData(true);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        if (inflater != null && menu.findItem(R.id.refresh_item) == null)
            inflater.inflate(R.menu.base_brick, menu);

    }

    @Override
    public void onResume() {
        super.onResume();
        if (m_Title != null)
            setTitle(m_Title);
    }

    @Override
    public void setTitle(String title) {
        m_Title = title;
        super.setTitle(title);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }
}
