package org.softeg.slartus.forpdaplus.core

import android.content.Context
import androidx.annotation.StringRes

interface AppActions {
    fun startDownload(url: String)
    fun showForumTopicsList(forumId: String?, forumTitle: String?)
    fun showQmsContactThreads(contactId: String, contactNick: String?)
    fun showQmsThread(
        contactId: String,
        contactNick: String?,
        threadId: String,
        threadTitle: String?
    )

    fun showUserProfile(contactId: String, contactNick: String?)
    fun showNewQmsContactThread(contactId: String, contactNick: String?)
    fun showUrlActions(context: Context, @StringRes titleRes: Int, url: String)
    fun showUrlActions(context: Context, title: String, url: String)
    fun openTopic(topicUrl: String)
}