package org.softeg.slartus.forpdaplus

import android.content.SharedPreferences
import android.graphics.Color
import kotlinx.coroutines.runBlocking
import ru.softeg.slartus.common.api.*

object AppTheme {
    @JvmStatic
    var appTheme: ru.softeg.slartus.common.api.AppTheme? = null

    @JvmStatic
    var appStyle: AppStyle
        get() {
            // TODO: Change
            return runBlocking {
                requireNotNull(appTheme).getStyle()
            }
        }
        set(value) {
            runBlocking { // TODO: Remove blocking
                requireNotNull(appTheme).putStyle(value)
            }
        }

    var mainAccent: AppAccentColor
        get() {
            return runBlocking {   // TODO: Remove blocking
                requireNotNull(appTheme).getAccentColor()
            }
        }
        set(value) {
            runBlocking { // TODO: Remove blocking
                requireNotNull(appTheme).putAccentColor(value)
            }
        }

    @JvmStatic
    val mainAccentColor: Int
        get() {
            return mainAccent.colorResId
        }

    @JvmStatic
    val webViewFont: String?
        get() = preferences.getString("webViewFontName", "")

    @JvmStatic
    fun getStatusBarBackgroundColorResId(): Int {
        return when (appStyle.type) {
            AppStyleType.Light -> R.color.statusBar_light
            AppStyleType.Dark -> R.color.statusBar_dark
            AppStyleType.Black -> R.color.statusBar_black
        }
    }

    @JvmStatic
    fun getColorAccent(type: AppAccentColorType): Int {
        return when (type) {
            AppAccentColorType.Accent -> preferences.getInt(
                "accentColor",
                AppAccentColor.Blue.colorRgb
            )
            AppAccentColorType.Pressed -> preferences.getInt(
                "accentColorPressed",
                AppAccentColor.Blue.pressedColorRgb
            )
        }
    }

    @JvmStatic
    val themeStyleResID: Int
        get() {
            return when (appStyle.type) {
                AppStyleType.Light -> {
                    when (mainAccent) {
                        AppAccentColor.Blue -> R.style.MainBlueLight
                        AppAccentColor.Gray -> R.style.MainGrayLight
                        AppAccentColor.Pink -> R.style.MainPinkLight
                    }
                }
                AppStyleType.Black -> {
                    when (mainAccent) {
                        AppAccentColor.Blue -> R.style.MainBlueBlack
                        AppAccentColor.Gray -> R.style.MainGrayBlack
                        AppAccentColor.Pink -> R.style.MainPinkBlack
                    }
                }
                AppStyleType.Dark -> {
                    when (mainAccent) {
                        AppAccentColor.Blue -> R.style.MainBlueDark
                        AppAccentColor.Gray -> R.style.MainGrayDark
                        AppAccentColor.Pink -> R.style.MainPinkDark
                    }
                }
            }
        }

    @JvmStatic
    val prefsThemeStyleResID: Int
        get() = when (appStyle.type) {
            AppStyleType.Light -> {
                when (mainAccent) {
                    AppAccentColor.Blue -> R.style.ThemePrefsLightBlue
                    AppAccentColor.Gray -> R.style.ThemePrefsLightGray
                    AppAccentColor.Pink -> R.style.ThemePrefsLightPink
                }
            }
            AppStyleType.Black -> {
                when (mainAccent) {
                    AppAccentColor.Blue -> R.style.ThemePrefsDarkBlue
                    AppAccentColor.Gray -> R.style.ThemePrefsDarkGray
                    AppAccentColor.Pink -> R.style.ThemePrefsDarkPink
                }
            }
            AppStyleType.Dark -> {
                when (mainAccent) {
                    AppAccentColor.Blue -> R.style.ThemePrefsBlackBlue
                    AppAccentColor.Gray -> R.style.ThemePrefsBlackGray
                    AppAccentColor.Pink -> R.style.ThemePrefsBlackPink
                }
            }
        }

    @JvmStatic
    val themeBackgroundColorRes: Int
        get() = when (appStyle.type) {
            AppStyleType.Light -> R.color.app_background_light
            AppStyleType.Dark -> R.color.app_background_dark
            AppStyleType.Black -> R.color.app_background_black
        }

    @JvmStatic
    val themeTextColorRes: Int
        get() = when (appStyle.type) {
            AppStyleType.Light -> android.R.color.black
            AppStyleType.Dark -> android.R.color.white
            AppStyleType.Black -> android.R.color.white
        }

    @JvmStatic
    val swipeRefreshBackground: Int
        get() = when (appStyle.type) {
            AppStyleType.Light -> R.color.swipe_background_light
            AppStyleType.Dark -> R.color.swipe_background_dark
            AppStyleType.Black -> R.color.swipe_background_black
        }

    @JvmStatic
    val navBarColor: Int
        get() = when (appStyle.type) {
            AppStyleType.Light -> R.color.navBar_light
            AppStyleType.Dark -> R.color.navBar_dark
            AppStyleType.Black -> R.color.navBar_black
        }

    @JvmStatic
    val drawerMenuText: Int
        get() = when (appStyle.type) {
            AppStyleType.Light -> R.color.drawer_menu_text_light
            AppStyleType.Dark -> R.color.drawer_menu_text_dark
            AppStyleType.Black -> R.color.drawer_menu_text_dark
        }

    @JvmStatic
    val currentBackgroundColorHtml: String
        get() = appStyle.htmlBackgroundColor

    @JvmStatic
    val themeStyleWebViewBackground: Int
        get() = Color.parseColor(currentBackgroundColorHtml)

    @JvmStatic
    val currentThemeName: String
        get() = when (appStyle.type) {
            AppStyleType.Light -> "white"
            AppStyleType.Dark -> "dark"
            AppStyleType.Black -> "black"
        }

    @JvmStatic
    val themeCssFileName: String get() = appStyle.getCssFilePath(mainAccent)

    private val preferences: SharedPreferences
        get() = App.getInstance().preferences
}

private val AppAccentColor.colorResId: Int
    get() = when (this) {
        AppAccentColor.Pink -> R.color.accentPink
        AppAccentColor.Blue -> R.color.accentBlue
        AppAccentColor.Gray -> R.color.accentGray
    }