package org.smssecure.smssecure.sms;

import org.smssecure.smssecure.database.model.SmsMessageRecord;
import org.smssecure.smssecure.recipients.Recipients;

public class OutgoingTextMessage {

  private final Recipients recipients;
  private final String     message;
  private final int        subscriptionId;

  public OutgoingTextMessage(Recipients recipients, String message, int subscriptionId) {
    this.recipients     = recipients;
    this.message        = message;
    this.subscriptionId = subscriptionId;
  }

  protected OutgoingTextMessage(OutgoingTextMessage base, String body) {
    this.recipients     = base.getRecipients();
    this.subscriptionId = base.getSubscriptionId();
    this.message        = body;
  }

  public int getSubscriptionId() {
    return subscriptionId;
  }

  public String getMessageBody() {
    return message;
  }

  public Recipients getRecipients() {
    return recipients;
  }

  public boolean isKeyExchange() {
    return false;
  }

  public boolean isSecureMessage() {
    return false;
  }

  public boolean isEndSession() {
    return false;
  }

  public boolean isPreKeyBundle() {
    return false;
  }

  public static OutgoingTextMessage from(SmsMessageRecord record) {
    if (record.isSecure()) {
      return new OutgoingEncryptedMessage(record.getRecipients(), record.getBody().getBody(), record.getSubscriptionId());
    } else if (record.isKeyExchange()) {
      return new OutgoingKeyExchangeMessage(record.getRecipients(), record.getBody().getBody(), record.getSubscriptionId());
    } else if (record.isEndSession()) {
      return new OutgoingEndSessionMessage(new OutgoingTextMessage(record.getRecipients(), record.getBody().getBody(), record.getSubscriptionId()));
    } else {
      return new OutgoingTextMessage(record.getRecipients(), record.getBody().getBody(), record.getSubscriptionId());
    }
  }

  public OutgoingTextMessage withBody(String body) {
    return new OutgoingTextMessage(this, body);
  }
}
