/**
 * Copyright (C) 2015 Open Whisper Systems
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.smssecure.smssecure.mms;

import java.io.InputStream;

public class MediaStream {
  private final InputStream stream;
  private final String      mimeType;

  public MediaStream(InputStream stream, String mimeType) {
    this.stream   = stream;
    this.mimeType = mimeType;
  }

  public InputStream getStream() {
    return stream;
  }

  public String getMimeType() {
    return mimeType;
  }
}
