( function ( $ ) {
	'use strict';

	var paInScript = {
		id: 'pa-inscript',
		name: 'Punjabi InScript',
		description: 'InScript keyboard for Punjabi script',
		date: '2012-10-16',
		author: '',
		license: '',
		version: '1.0',
		patterns: [
			['1', '੧'],
			['2', '੨'],
			['3', '੩'],
			['4', '੪'],
			['5', '੫'],
			['6', '੬'],
			['7', '੭'],
			['8', '੮'],
			['9', '੯'],
			['0', '੦'],
			['\\_', '_'],
			['\\-', '-'],
			['\\+', '+'],
			['\\=', '='],
			['Q', 'ਔ'],
			['q', 'ੌ'],
			['W', 'ਐ'],
			['w', 'ੈ'],
			['E', 'ਆ'],
			['e', 'ਾ'],
			['R', 'ਈ'],
			['r', 'ੀ'],
			['T', 'ਊ'],
			['t', 'ੂ'],
			['Y', 'ਭ'],
			['y', 'ਬ'],
			['U', 'ਙ'],
			['u', 'ਹ'],
			['I', 'ਘ'],
			['i', 'ਗ'],
			['O', 'ਧ'],
			['o', 'ਦ'],
			['P', 'ਝ'],
			['p', 'ਜ'],
			['\\{', 'ਢ'],
			['\\[', 'ਡ'],
			['\\}', 'ਞ'],
			['\\]', '਼'],
			['A', 'ਓ'],
			['a', 'ੋ'],
			['S', 'ਏ'],
			['s', 'ੇ'],
			['D', 'ਅ'],
			['d', '੍'],
			['F', 'ਇ'],
			['f', 'ਿ'],
			['G', 'ਉ'],
			['g', 'ੁ'],
			['H', 'ਫ'],
			['h', 'ਪ'],
			['J', 'ੜ'],
			['j', 'ਰ'],
			['K', 'ਖ'],
			['k', 'ਕ'],
			['L', 'ਥ'],
			['l', 'ਤ'],
			['\\:', 'ਛ'],
			['\\;', 'ਚ'],
			['\\"', 'ਠ'],
			['\'', 'ਟ'],
			['Z', 'ੱ'],
			['z', 'ੰ'],
			['X', 'ਫ਼'],
			['x', 'ਜ਼'],
			['C', 'ਣ'],
			['c', 'ਮ'],
			['V', 'ਂ'],
			['v', 'ਨ'],
			['B', 'ਞ'],
			['b', 'ਵ'],
			['N', 'ਲ਼'],
			['n', 'ਲ'],
			['M', 'ਸ਼'],
			['m', 'ਸ'],
			['\\<', 'ੳ'],
			[',', ','],
			['\\>', 'ੲ'],
			['\\.', '.'],
			['\\?', '?'],
			['/', 'ਯ']]

	};
	$.ime.register( paInScript );

}( jQuery ) );
