( function ( $ ) {
	'use strict';

	var eoVi = {
		id: 'eo-vi',
		name: 'Esperanto vi',
		description: 'writing Esperanto-letters using double key press (the X-system).',
		date: '2013-02-12',
		URL: 'http://github.com/wikimedia/jquery.ime',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			['ĉc', 'cc'],
			['ĝg', 'gg'],
			['ĥh', 'hh'],
			['ĵj', 'jj'],
			['ŝs', 'ss'],
			['ŭu', 'uu'],
			['Ĉc', 'Cc'],
			['Ĝg', 'Gg'],
			['Ĥh', 'Hh'],
			['Ĵj', 'Jj'],
			['Ŝs', 'Ss'],
			['Ŭu', 'Uu'],
			['aŭu', 'au'],
			['eŭu', 'eu'],
			['Aŭu', 'Au'],
			['Eŭu', 'Eu'],
			['AŬU', 'AU'],
			['EŬU', 'EU'],
			['ĈC', 'CC'],
			['ĜG', 'GG'],
			['ĤH', 'HH'],
			['ĴJ', 'JJ'],
			['ŜS', 'SS'],
			['ŬU', 'UU'],
			['cc', 'ĉ'],
			['gg', 'ĝ'],
			['hh', 'ĥ'],
			['jj', 'ĵ'],
			['ss', 'ŝ'],
			['uu', 'ŭ'],
			['au', 'aŭ'],
			['eu', 'eŭ'],
			['Cc', 'Ĉ'],
			['Gg', 'Ĝ'],
			['Hh', 'Ĥ'],
			['Jj', 'Ĵ'],
			['Ss', 'Ŝ'],
			['Uu', 'Ŭ'],
			['Au', 'Aŭ'],
			['Eu', 'Eŭ'],
			['AU', 'AŬ'],
			['EU', 'EŬ'],
			['CC', 'Ĉ'],
			['GG', 'Ĝ'],
			['HH', 'Ĥ'],
			['JJ', 'Ĵ'],
			['SS', 'Ŝ'],
			['UU', 'Ŭ']]
	};

	$.ime.register( eoVi );

}( jQuery ) );
