( function ( $ ) {
	'use strict';

	var skKbd = {
		id: 'sk-kbd',
		name: 'Slovak kbd',
		description: 'Slovak kbd keyboard layout',
		date: '2013-02-12',
		URL: 'http://github.com/wikimedia/jquery.ime',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			['+\'a', 'ä'],
			['+\'o', 'ö'],
			['+\'u', 'ü'],
			['+\'A', 'Ä'],
			['+\'O', 'Ö'],
			['+\'U', 'Ü'],

			['\'a', 'á'],
			['+a', 'ä'],
			['+c', 'č'],
			['+d', 'ď'],
			['\'e', 'é'],
			['+e', 'ě'],
			['\'i', 'í'],
			['\'l', 'ĺ'],
			['+l', 'ľ'],
			['+n', 'ň'],
			['\'o', 'ó'],
			['+o', 'ô'],
			['^o', 'ô'],
			['\'r', 'ŕ'],
			['+r', 'ř'],
			['\'s', 'ß'],
			['+s', 'š'],
			['+t', 'ť'],
			['\'u', 'ú'],
			['+u', 'ů'],
			['\'z', 'ý'],
			['+y', 'ž'],
			['\'A', 'Á'],
			['+A', 'Ä'],
			['+C', 'Č'],
			['+D', 'Ď'],
			['\'E', 'É'],
			['+E', 'Ě'],
			['\'I', 'Í'],
			['\'L', 'Ĺ'],
			['+L', 'Ľ'],
			['+N', 'Ň'],
			['\'O', 'Ó'],
			['+O', 'Ô'],
			['~O', 'Ô'],
			['\'R', 'Ŕ'],
			['+R', 'Ř'],
			['\'S', 'ß'],
			['+S', 'Š'],
			['+T', 'Ť'],
			['\'U', 'Ú'],
			['+U', 'Ů'],
			['\'Z', 'Ý'],
			['+Y', 'Ž'],
			['\'q', '`'],
			['\'2', '@'],
			['\'3', '#'],
			['\'4', '$'],
			['\'5', '%'],
			['\'6', '^'],
			['\'7', '&'],
			['\'8', '*'],
			['\'9', '('],
			['\'0', ')'],
			['+1', '!'],
			['+2', '@'],
			['+3', '#'],
			['+4', '$'],
			['+5', '%'],
			['+6', '^'],
			['+7', '&'],
			['+8', '*'],
			['+9', '('],
			['+0', ')'],
			['1', '+'],
			['2', 'ľ'],
			['3', 'š'],
			['4', 'č'],
			['5', 'ť'],
			['6', 'ž'],
			['7', 'ý'],
			['8', 'á'],
			['9', 'í'],
			['0', 'é'],
			['\\!', '1'],
			['\\@', '2'],
			['\\#', '3'],
			['\\$', '4'],
			['\\%', '5'],
			['\\^', '6'],
			['\\&', '7'],
			['\\*', '8'],
			['\\(', '9'],
			['\\)', '0'],
			['\\-', '='],
			['\\_', '%'],
			['\\=', '\''],
			['\\[', 'ú'],
			['\\{', '/'],
			['\\]', 'ä'],
			['\\}', '('],
			['\\\\', 'ň'],
			['\\|', ')'],
			[';', 'ô'],
			[':', '\"'],
			['\'', '§'],
			['\"', '!'],
			['\\<', '?'],
			['\\>', ':'],
			['/', '-'],
			['\\?', '_'],
			['`', ';'],
			['\\~', '^'],
			['y', 'z'],
			['z', 'y'],
			['Y', 'Z'],
			['Z', 'Y']]
	};
	$.ime.register( skKbd );

}( jQuery ) );

