# Privacy Policy

*Last updated: 2022-04-24*

RedReader is an Android application licensed under the GNU Public License (GPL), version 3. See [LICENSE.txt](LICENSE.txt) for the full text of this license.

This privacy policy aims to provide information on how RedReader handles your data. This policy may be updated at any time for any reason, and this will be indicated by updating the "last updated" date at the top of the policy.

Note that the GPL version 3 remains the only license under which RedReader is distributed, and so this policy is provided for informational purposes only, and not as a legally binding agreement.

## Overview

Privacy is a core goal for RedReader, and so it:

* **Doesn't collect any data about you, or your device.**
  * It does, however, access third party services such as Reddit, which have their own privacy policies and may collect data. See the "Third Party Services" section below.
* **Contains no third party SDKs for adverts, analytics, or telemetry.**
  * In fact, it contains no closed-source components at all.
* **Only sends error reports by email, and only if you actually click "report".**
  * If you choose to report an error, the details are passed to your email client, and from there you can decide what to send/not send.
  * Note: if you have Google Play Services installed on your device, this may collect crash reports from all applications, including RedReader. See the "App stores" section below.
* **Doesn't request any unnecessary Android permissions.**

RedReader is open source, which means that anyone can review the source code and see for themselves how it works. So feel free to take a look and verify the above for yourself!

## Data Stored on Your Device

When you use RedReader, data including (but not limited to) the following may be stored locally on your device.

* App preferences
* Your logged-in Reddit accounts
* Information downloaded from Reddit about your account, such as subscribed subreddits/users, voting activity, your inbox contents, etc
* A cache of previously visited/read pages

## Third Party Services

RedReader is similar to a web browser in that it can be used to access a variety of third party services. These are not operated by the RedReader developers, and therefore you are advised to review the privacy policies of these third party services.

RedReader accesses the Reddit API. This may occur while the app is in use, or periodically in the background to fetch messages and notifications. Reddit is a third party service and outside the scope of this privacy policy. Reddit's privacy policy is available here:

https://www.redditinc.com/policies/privacy-policy

RedReader downloads images and other data from third party websites linked to by Reddit posts and comments. This may occur when you click a link, or automatically in the background when viewing a post list (if pre-caching is enabled in the preferences). Also, these services may be accessed directly through the original link, or through an API if one is available. Again, the privacy policies of these third party websites are outside the scope of RedReader's privacy policy.    


## App Stores

This policy does not apply to the third party app store(s) from which you obtained RedReader, such as Google Play or F-Droid. Please consult the relevant policies of those third parties.

Google Play provides app developers with various statistics and crash logs. These are collected by Google Play Services, which is not part of RedReader and is outside the scope of this privacy policy.

## Minimum Age

RedReader is not targeted at anyone below the age of 18.

## Questions

If you have any questions or concerns about this policy, please contact [@QuantumBadger](https://old.reddit.com/message/compose/?to=QuantumBadger).
