package org.pyload.android.client.components;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.widget.TextView;

public class ScrollingTextView extends TextView {

	public ScrollingTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);

        int white = getResources().getColor(android.R.color.white);
        setTextColor(white);
	}

	public ScrollingTextView(Context context, AttributeSet attrs) {
		super(context, attrs);

	}

	public ScrollingTextView(Context context) {
		super(context);

	}

	@Override
	protected void onFocusChanged(boolean focused, int direction,
			Rect previouslyFocusedRect) {

		if (focused)
			super.onFocusChanged(focused, direction, previouslyFocusedRect);

	}

	@Override
	public void onWindowFocusChanged(boolean focused) {

		if (focused)
			super.onWindowFocusChanged(focused);

	}

	@Override
	public boolean isFocused() {
		return true;

	}

}