"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPluginMimeTypeMiddleware = void 0;
/**
 * Sets up a middleware which allows plugins to resolve the mime type.
 */
function createPluginMimeTypeMiddleware(cfg) {
    const mimeTypePlugins = cfg.plugins.filter(p => 'resolveMimeType' in p);
    if (mimeTypePlugins.length === 0) {
        // nothing to transform
        return (ctx, next) => next();
    }
    return async function pluginMimeTypeMiddleware(context, next) {
        var _a;
        await next();
        if (context.status < 200 || context.status >= 300) {
            return undefined;
        }
        for (const plugin of mimeTypePlugins) {
            const type = await ((_a = plugin.resolveMimeType) === null || _a === void 0 ? void 0 : _a.call(plugin, context));
            if (type) {
                context.type = type;
            }
        }
    };
}
exports.createPluginMimeTypeMiddleware = createPluginMimeTypeMiddleware;
//# sourceMappingURL=plugin-mime-type.js.map