import * as React from 'react';
import React__default, { memo, useState, useEffect, useRef, Fragment } from 'react';
import { useGlobals, useParameter, useStorybookApi, addons, types } from 'storybook/internal/manager-api';
import memoize from 'memoizerific';
import { styled, withTheme, Global } from 'storybook/internal/theming';
import { IconButton, WithTooltip, TooltipLinkList } from 'storybook/internal/components';
import { GrowIcon, TransferIcon } from '@storybook/icons';

var ADDON_ID="storybook/viewport",PARAM_KEY="viewport";var initialGlobals={viewport:"reset",viewportRotated:!1};var getCurrentViewportIndex=(viewportsKeys,current)=>viewportsKeys.indexOf(current),getNextViewport=(viewportsKeys,current)=>{let currentViewportIndex=getCurrentViewportIndex(viewportsKeys,current);return currentViewportIndex===viewportsKeys.length-1?viewportsKeys[0]:viewportsKeys[currentViewportIndex+1]},getPreviousViewport=(viewportsKeys,current)=>{let currentViewportIndex=getCurrentViewportIndex(viewportsKeys,current);return currentViewportIndex<1?viewportsKeys[viewportsKeys.length-1]:viewportsKeys[currentViewportIndex-1]},registerShortcuts=async(api,globals,updateGlobals,viewportsKeys)=>{await api.setAddonShortcut(ADDON_ID,{label:"Previous viewport",defaultShortcut:["alt","shift","V"],actionName:"previous",action:()=>{updateGlobals({viewport:getPreviousViewport(viewportsKeys,globals.viewport)});}}),await api.setAddonShortcut(ADDON_ID,{label:"Next viewport",defaultShortcut:["alt","V"],actionName:"next",action:()=>{updateGlobals({viewport:getNextViewport(viewportsKeys,globals.viewport)});}}),await api.setAddonShortcut(ADDON_ID,{label:"Reset viewport",defaultShortcut:["alt","control","V"],actionName:"reset",action:()=>{updateGlobals(initialGlobals);}});};var MINIMAL_VIEWPORTS={mobile1:{name:"Small mobile",styles:{height:"568px",width:"320px"},type:"mobile"},mobile2:{name:"Large mobile",styles:{height:"896px",width:"414px"},type:"mobile"},tablet:{name:"Tablet",styles:{height:"1112px",width:"834px"},type:"tablet"}};var toList=memoize(50)(items=>[...baseViewports,...Object.entries(items).map(([id,{name,...rest}])=>({...rest,id,title:name}))]),responsiveViewport={id:"reset",title:"Reset viewport",styles:null,type:"other"},baseViewports=[responsiveViewport],toLinks=memoize(50)((list,active,updateGlobals,close)=>list.filter(i=>i.id!==responsiveViewport.id||active.id!==i.id).map(i=>({...i,onClick:()=>{updateGlobals({viewport:i.id}),close();}}))),flip=({width,height,...styles})=>({...styles,height:width,width:height}),ActiveViewportSize=styled.div(()=>({display:"inline-flex",alignItems:"center"})),ActiveViewportLabel=styled.div(({theme})=>({display:"inline-block",textDecoration:"none",padding:10,fontWeight:theme.typography.weight.bold,fontSize:theme.typography.size.s2-1,lineHeight:"1",height:40,border:"none",borderTop:"3px solid transparent",borderBottom:"3px solid transparent",background:"transparent"})),IconButtonWithLabel=styled(IconButton)(()=>({display:"inline-flex",alignItems:"center"})),IconButtonLabel=styled.div(({theme})=>({fontSize:theme.typography.size.s2-1,marginLeft:10})),getStyles=(prevStyles,styles,isRotated)=>{if(styles===null)return;let result=typeof styles=="function"?styles(prevStyles):styles;return isRotated?flip(result):result},ViewportTool=memo(withTheme(({theme})=>{let[globals,updateGlobals]=useGlobals(),{viewports=MINIMAL_VIEWPORTS,defaultOrientation,defaultViewport,disable}=useParameter(PARAM_KEY,{}),list=toList(viewports),api=useStorybookApi(),[isTooltipVisible,setIsTooltipVisible]=useState(!1);defaultViewport&&!list.find(i=>i.id===defaultViewport)&&console.warn(`Cannot find "defaultViewport" of "${defaultViewport}" in addon-viewport configs, please check the "viewports" setting in the configuration.`),useEffect(()=>{registerShortcuts(api,globals,updateGlobals,Object.keys(viewports));},[viewports,globals,globals.viewport,updateGlobals,api]),useEffect(()=>{let defaultRotated=defaultOrientation==="landscape";(defaultViewport&&globals.viewport!==defaultViewport||defaultOrientation&&globals.viewportRotated!==defaultRotated)&&updateGlobals({viewport:defaultViewport,viewportRotated:defaultRotated});},[defaultOrientation,defaultViewport,updateGlobals]);let item=list.find(i=>i.id===globals.viewport)||list.find(i=>i.id===defaultViewport)||list.find(i=>i.default)||responsiveViewport,ref=useRef(),styles=getStyles(ref.current,item.styles,globals.viewportRotated);return useEffect(()=>{ref.current=styles;},[item]),disable||Object.entries(viewports).length===0?null:React__default.createElement(Fragment,null,React__default.createElement(WithTooltip,{placement:"top",tooltip:({onHide})=>React__default.createElement(TooltipLinkList,{links:toLinks(list,item,updateGlobals,onHide)}),closeOnOutsideClick:!0,onVisibleChange:setIsTooltipVisible},React__default.createElement(IconButtonWithLabel,{key:"viewport",title:"Change the size of the preview",active:isTooltipVisible||!!styles,onDoubleClick:()=>{updateGlobals({viewport:responsiveViewport.id});}},React__default.createElement(GrowIcon,null),styles?React__default.createElement(IconButtonLabel,null,globals.viewportRotated?`${item.title} (L)`:`${item.title} (P)`):null)),styles?React__default.createElement(ActiveViewportSize,null,React__default.createElement(Global,{styles:{'iframe[data-is-storybook="true"]':{...styles||{width:"100%",height:"100%"}}}}),React__default.createElement(ActiveViewportLabel,{title:"Viewport width"},styles.width.replace("px","")),React__default.createElement(IconButton,{key:"viewport-rotate",title:"Rotate viewport",onClick:()=>{updateGlobals({viewportRotated:!globals.viewportRotated});}},React__default.createElement(TransferIcon,null)),React__default.createElement(ActiveViewportLabel,{title:"Viewport height"},styles.height.replace("px",""))):null)}));addons.register(ADDON_ID,()=>{addons.add(ADDON_ID,{title:"viewport / media-queries",type:types.TOOL,match:({viewMode,tabId})=>viewMode==="story"&&!tabId,render:()=>React.createElement(ViewportTool,null)});});
