import { UserAgentCompat } from './user-agent-compat';
import { PolyfillsLoaderConfig as OriginalPolyfillsLoaderConfig, GeneratedFile } from 'polyfills-loader';
export interface PolyfillsLoaderConfig extends OriginalPolyfillsLoaderConfig {
    exclude?: {
        jsModules?: boolean;
        inlineJsModules?: boolean;
        jsScripts?: boolean;
        inlineJsScripts?: boolean;
    };
}
export interface InjectPolyfillsLoaderConfig {
    compatibilityMode: string;
    uaCompat: UserAgentCompat;
    htmlString: string;
    indexUrl: string;
    indexFilePath: string;
    polyfillsLoaderConfig?: Partial<PolyfillsLoaderConfig>;
}
/**
 * transforms index.html, extracting any modules and import maps and adds them back
 * with the appropriate polyfills, shims and a script loader so that they can be loaded
 * at the right time
 */
export declare function injectPolyfillsLoader(cfg: InjectPolyfillsLoaderConfig): Promise<{
    indexHTML: string;
    inlineScripts: GeneratedFile[];
    polyfills: GeneratedFile[];
}>;
