/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import '@polymer/polymer/polymer-legacy.js';

import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';
import {NeonSharedElementAnimationBehavior} from '../neon-shared-element-animation-behavior.js';
/*
`<ripple-animation>` scales and transform an element such that it appears to
ripple from either a shared element, or from a screen position, to full screen.

If using as a shared element animation in `<neon-animated-pages>`, use this
animation in an `exit` animation in the source page and in an `entry` animation
in the destination page. Also, define the hero elements in the `sharedElements`
property (not a configuration property, see
`NeonSharedElementAnimatableBehavior`).

If using a screen position, define the `gesture` property.

Configuration:
```
{
  name: 'ripple-animation`.
  id: <shared-element-id>, /* set this or gesture *\/
  gesture: {x: <page-x>, y: <page-y>}, /* set this or id *\/
  timing: <animation-timing>,
  toPage: <node>, /* define for the destination page *\/
  fromPage: <node>, /* define for the source page *\/
}
```
*/
Polymer({

  is: 'ripple-animation',

  behaviors: [NeonSharedElementAnimationBehavior],

  configure: function(config) {
    var shared = this.findSharedElements(config);
    if (!shared) {
      return null;
    }

    var translateX, translateY;
    var toRect = shared.to.getBoundingClientRect();
    if (config.gesture) {
      translateX = config.gesture.x - (toRect.left + (toRect.width / 2));
      translateY = config.gesture.y - (toRect.top + (toRect.height / 2));
    } else {
      var fromRect = shared.from.getBoundingClientRect();
      translateX = (fromRect.left + (fromRect.width / 2)) -
          (toRect.left + (toRect.width / 2));
      translateY = (fromRect.top + (fromRect.height / 2)) -
          (toRect.top + (toRect.height / 2));
    }
    var translate = 'translate(' + translateX + 'px,' + translateY + 'px)';

    var size = Math.max(
        toRect.width + Math.abs(translateX) * 2,
        toRect.height + Math.abs(translateY) * 2);
    var diameter = Math.sqrt(2 * size * size);
    var scaleX = diameter / toRect.width;
    var scaleY = diameter / toRect.height;
    var scale = 'scale(' + scaleX + ',' + scaleY + ')';

    this._effect = new KeyframeEffect(
        shared.to,
        [
          {'transform': translate + ' scale(0)'},
          {'transform': translate + ' ' + scale}
        ],
        this.timingFromConfig(config));

    this.setPrefixedProperty(shared.to, 'transformOrigin', '50% 50%');
    shared.to.style.borderRadius = '50%';

    return this._effect;
  },

  complete: function() {
    if (this.sharedElements) {
      this.setPrefixedProperty(this.sharedElements.to, 'transformOrigin', '');
      this.sharedElements.to.style.borderRadius = '';
    }
  }

});
