"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.babelTransformPlugin = void 0;
const compatibility_transform_1 = require("../utils/compatibility-transform");
const user_agent_compat_1 = require("../utils/user-agent-compat");
const dom5_fork_1 = require("@open-wc/building-utils/dom5-fork");
const building_utils_1 = require("@open-wc/building-utils");
const parse5_1 = require("parse5");
const url_1 = require("url");
const utils_1 = require("../utils/utils");
const plugin_transform_1 = require("../middleware/plugin-transform");
function createFilePath(context, rootDir) {
    const path = context.path.endsWith('/') ? `${context.path}index.html` : context.path;
    return url_1.fileURLToPath(new url_1.URL(`.${path}`, `${url_1.pathToFileURL(rootDir)}/`));
}
function babelTransformPlugin(config) {
    const compatibilityTransform = compatibility_transform_1.createCompatibilityTransform(config);
    const { rootDir } = config;
    async function transformJs(context, code) {
        const filePath = createFilePath(context, rootDir);
        const transformModule = context.URL.searchParams.has('transform-systemjs');
        const uaCompat = user_agent_compat_1.getUserAgentCompat(context);
        try {
            return await compatibilityTransform({
                uaCompat,
                filePath,
                code,
                transformModule,
            });
        }
        catch (error) {
            throw new plugin_transform_1.TransformSyntaxError(error.message);
        }
    }
    return {
        async transform(context) {
            // transform a single file
            if (context.response.is('js') && !utils_1.isPolyfill(context.url)) {
                return { body: await transformJs(context, context.body) };
            }
            // transform inline JS
            if (context.response.is('html')) {
                const documentAst = parse5_1.parse(context.body);
                const scriptNodes = building_utils_1.findJsScripts(documentAst, {
                    jsScripts: true,
                    jsModules: true,
                });
                for (const node of scriptNodes) {
                    const code = dom5_fork_1.getTextContent(node);
                    const resolvedCode = await transformJs(context, code);
                    dom5_fork_1.setTextContent(node, resolvedCode);
                }
                return { body: parse5_1.serialize(documentAst) };
            }
        },
    };
}
exports.babelTransformPlugin = babelTransformPlugin;
//# sourceMappingURL=babelTransformPlugin.js.map