export { Breadcrumb, BreadcrumbHint, PolymorphicRequest, Request, SdkInfo, Event, EventHint, Exception, Session, Severity, SeverityLevel, Span, StackFrame, Stacktrace, Thread, Transaction, User, } from '@sentry/types';
export { AddRequestDataToEventOptions, TransactionNamingScheme } from '@sentry/utils';
export { NodeOptions } from './types';
export { addGlobalEventProcessor, addEventProcessor, addBreadcrumb, addIntegration, captureException, captureEvent, captureMessage, close, configureScope, createTransport, extractTraceparentData, flush, getActiveTransaction, getHubFromCarrier, getCurrentHub, getClient, getCurrentScope, getGlobalScope, getIsolationScope, Hub, lastEventId, makeMain, runWithAsyncContext, Scope, startTransaction, SDK_VERSION, setContext, setExtra, setExtras, setTag, setTags, setUser, spanStatusfromHttpCode, trace, withScope, captureCheckIn, withMonitor, setMeasurement, getActiveSpan, startSpan, startActiveSpan, startInactiveSpan, startSpanManual, continueTrace, metrics, } from '@sentry/core';
export { SpanStatusType } from '@sentry/core';
export { autoDiscoverNodePerformanceMonitoringIntegrations } from './tracing';
export { NodeClient } from './client';
export { makeNodeTransport } from './transports';
export { defaultIntegrations, init, defaultStackParser, getSentryRelease } from './sdk';
export { addRequestDataToEvent, DEFAULT_USER_INCLUDES, extractRequestData } from '@sentry/utils';
export { deepReadDirSync } from './utils';
export { getModuleFromFilename } from './module';
export { enableAnrDetection } from './integrations/anr/legacy';
import { Integration, IntegrationClass } from '@sentry/types';
import * as Handlers from './handlers';
import * as NodeIntegrations from './integrations';
import * as TracingIntegrations from './tracing/integrations';
declare const INTEGRATIONS: {
    Apollo: typeof TracingIntegrations.Apollo;
    Express: typeof TracingIntegrations.Express;
    GraphQL: typeof TracingIntegrations.GraphQL;
    Mongo: typeof TracingIntegrations.Mongo;
    Mysql: typeof TracingIntegrations.Mysql;
    Postgres: typeof TracingIntegrations.Postgres;
    Prisma: typeof TracingIntegrations.Prisma;
    Console: IntegrationClass<Integration>;
    Http: typeof NodeIntegrations.Http;
    OnUncaughtException: IntegrationClass<Integration>;
    OnUnhandledRejection: IntegrationClass<Integration>;
    Modules: IntegrationClass<Integration>;
    ContextLines: IntegrationClass<Integration>;
    Context: IntegrationClass<Integration>;
    RequestData: IntegrationClass<Integration>;
    LocalVariables: IntegrationClass<Integration>;
    Undici: typeof NodeIntegrations.Undici;
    Spotlight: IntegrationClass<Integration>;
    Anr: IntegrationClass<Integration>;
    Hapi: IntegrationClass<Integration>;
    FunctionToString: Integration & {
        new (...args: any[]): Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    InboundFilters: Integration & {
        new (...args: any[]): Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    LinkedErrors: Integration & {
        new (...args: any[]): Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
};
export { INTEGRATIONS as Integrations, Handlers };
export { hapiErrorPlugin } from './integrations/hapi';
import { instrumentCron } from './cron/cron';
import { instrumentNodeCron } from './cron/node-cron';
/** Methods to instrument cron libraries for Sentry check-ins */
export declare const cron: {
    instrumentCron: typeof instrumentCron;
    instrumentNodeCron: typeof instrumentNodeCron;
};
//# sourceMappingURL=index.d.ts.map
