import { BrowserOptions } from '@sentry/browser';
import { RendererProcessAnrOptions } from '../common';
export declare const defaultIntegrations: (import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
    setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
})[];
interface ElectronRendererOptions extends BrowserOptions {
    /**
     * Enables ANR detection in this renderer process.
     *
     * Optionally accepts an object of options to configure ANR detection.
     *
     * {
     *   pollInterval: number; // Defaults to 1000ms
     *   anrThreshold: number; // Defaults to 5000ms
     *   captureStackTrace: boolean; // Defaults to false
     * }
     *
     * Defaults to 'false'.
     */
    anrDetection?: Partial<RendererProcessAnrOptions> | boolean;
}
/**
 * Initialize Sentry in the Electron renderer process
 * @param options SDK options
 * @param originalInit Optional init function for a specific framework SDK
 * @returns
 */
export declare function init<O extends ElectronRendererOptions>(options?: ElectronRendererOptions & O, originalInit?: (if_you_get_a_typescript_error_ensure_sdks_use_version_v7_92_0: O) => void): void;
export {};
//# sourceMappingURL=sdk.d.ts.map