import { convertIntegrationFnToClass } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

const INTEGRATION_NAME = 'MainProcessSession';
const mainProcessSession = (options = {}) => {
    return {
        name: INTEGRATION_NAME,
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
};
/** Tracks sessions as the main process lifetime. */
// eslint-disable-next-line deprecation/deprecation
const MainProcessSession = convertIntegrationFnToClass(INTEGRATION_NAME, mainProcessSession);

export { MainProcessSession };
//# sourceMappingURL=main-process-session.js.map
