import * as ElectronMainIntegrations from './integrations';
export type { Breadcrumb, BreadcrumbHint, PolymorphicRequest, Request, SdkInfo, Event, EventHint, Exception, Session, Severity, SeverityLevel, Span, StackFrame, Stacktrace, Thread, Transaction, User, } from '@sentry/types';
export { addGlobalEventProcessor, addEventProcessor, addBreadcrumb, addIntegration, captureException, captureEvent, captureMessage, configureScope, createTransport, extractTraceparentData, getActiveTransaction, getHubFromCarrier, getCurrentHub, getClient, getCurrentScope, getGlobalScope, getIsolationScope, Hub, makeMain, runWithAsyncContext, Scope, startTransaction, setContext, setExtra, setExtras, setTag, setTags, setUser, spanStatusfromHttpCode, trace, withScope, captureCheckIn, withMonitor, setMeasurement, getActiveSpan, startSpan, startActiveSpan, startInactiveSpan, startSpanManual, continueTrace, metrics, } from '@sentry/core';
export type { SpanStatusType } from '@sentry/core';
export type { NodeOptions } from '@sentry/node';
export { flush, close, NodeClient, lastEventId } from '@sentry/node';
export { makeElectronTransport } from './transports/electron-net';
export { makeElectronOfflineTransport } from './transports/electron-offline-net';
export declare const Integrations: {
    ElectronBreadcrumbs: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    OnUncaughtException: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    MainContext: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    SentryMinidump: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    ElectronMinidump: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    PreloadInjection: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    MainProcessSession: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    BrowserWindowSession: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    AdditionalContext: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    Net: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    ChildProcess: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    Screenshots: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    RendererProfiling: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    Anr: typeof ElectronMainIntegrations.Anr;
    Apollo: typeof import("@sentry-internal/tracing").Apollo;
    Express: typeof import("@sentry-internal/tracing").Express;
    GraphQL: typeof import("@sentry-internal/tracing").GraphQL;
    Mongo: typeof import("@sentry-internal/tracing").Mongo;
    Mysql: typeof import("@sentry-internal/tracing").Mysql;
    Postgres: typeof import("@sentry-internal/tracing").Postgres;
    Prisma: typeof import("@sentry-internal/tracing").Prisma;
    Console: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    Http: typeof import("@sentry/node/types/integrations").Http;
    OnUnhandledRejection: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    Modules: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    ContextLines: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    Context: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    RequestData: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    LocalVariables: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    Undici: typeof import("@sentry/node/types/integrations").Undici;
    Spotlight: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    Hapi: import("@sentry/types").IntegrationClass<import("@sentry/types").Integration>;
    FunctionToString: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    InboundFilters: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
    LinkedErrors: import("@sentry/types").Integration & {
        new (...args: any[]): import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
            setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
        };
        id: string;
    };
};
export type { ElectronMainOptions } from './sdk';
export { init, defaultIntegrations } from './sdk';
export { IPCMode } from '../common';
export { enableMainProcessAnrDetection } from './anr';
//# sourceMappingURL=index.d.ts.map