export declare const commandLineOptions: ({
    name: string;
    alias: string;
    type: StringConstructor;
    description: string;
    multiple?: undefined;
} | {
    name: string;
    alias: string;
    type: NumberConstructor;
    description: string;
    multiple?: undefined;
} | {
    name: string;
    type: StringConstructor;
    description: string;
    alias?: undefined;
    multiple?: undefined;
} | {
    name: string;
    alias: string;
    type: StringConstructor;
    multiple: boolean;
    description: string;
} | {
    name: string;
    alias: string;
    type: BooleanConstructor;
    description: string;
    multiple?: undefined;
} | {
    name: string;
    type: BooleanConstructor;
    description: string;
    alias?: undefined;
    multiple?: undefined;
} | {
    name: string;
    type: StringConstructor;
    multiple: boolean;
    description: string;
    alias?: undefined;
})[];
export interface CommandLineArgs {
    config?: string;
    port?: number;
    hostname?: string;
    open?: string | boolean;
    appIndex?: string;
    rootDir?: string;
    basePath?: string;
    moduleDirs?: string[];
    watch?: boolean;
    watchExcludes?: string;
    http2?: boolean;
    sslKey?: string;
    sslCert?: string;
    nodeResolve?: boolean;
    dedupe?: boolean;
    dedupeModules?: boolean;
    preserveSymlinks?: boolean;
    babel?: boolean;
    fileExtensions?: string[];
    babelExclude?: string[];
    babelModernExclude?: string[];
    compatibility?: string;
    debug?: boolean;
    logStartup: boolean;
    logCompileErrors: boolean;
    eventStream?: boolean;
}
/**
 * Reads command line args from arguments array. Defaults to `process.argv`.
 */
export declare function readCommandLineArgs(argv?: string[], config?: {
    defaultConfigDir?: string;
    defaultConfigName?: string;
}): CommandLineArgs;
