#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const es_dev_server_1 = require("./es-dev-server");
const command_line_args_1 = require("./command-line-args");
const utils_1 = require("./utils/utils");
const config = es_dev_server_1.createConfig({ ...command_line_args_1.readCommandLineArgs(), logErrorsToBrowser: true });
utils_1.logDebug('Starting server with config: ', config);
es_dev_server_1.startServer(config);
['exit', 'SIGINT'].forEach(event => {
    // @ts-ignore
    process.on(event, () => {
        process.exit(0);
    });
});
//# sourceMappingURL=cli.js.map